/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.auction;

import com.particles.msp.AdCache;
import com.particles.msp.api.AdListener;
import com.particles.msp.api.AdRequest;
import com.particles.msp.api.MSPAd;
import com.particles.msp.auction.AuctionBid;
import com.particles.msp.auction.AuctionBidListener;
import com.particles.msp.auction.AuctionListener;
import com.particles.msp.auction.Bidder;
import com.particles.msp.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ-\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/particles/msp/auction/Auction;", "", "bidders", "", "Lcom/particles/msp/auction/Bidder;", "adRequest", "Lcom/particles/msp/api/AdRequest;", "cacheOnly", "", "timeout", "", "(Ljava/util/List;Lcom/particles/msp/api/AdRequest;ZI)V", "fetchBid", "Lcom/particles/msp/auction/AuctionBid;", "bidder", "adListener", "Lcom/particles/msp/api/AdListener;", "(Lcom/particles/msp/auction/Bidder;Lcom/particles/msp/api/AdListener;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startAuction", "", "auctionListener", "Lcom/particles/msp/auction/AuctionListener;", "msp-core_mavenRelease"})
public final class Auction {
    @NotNull
    private final List<Bidder> bidders;
    @Nullable
    private final AdRequest adRequest;
    private final boolean cacheOnly;
    private final int timeout;

    public Auction(@NotNull List<? extends Bidder> bidders, @Nullable AdRequest adRequest, boolean cacheOnly, int timeout) {
        Intrinsics.checkNotNullParameter(bidders, (String)"bidders");
        this.bidders = bidders;
        this.adRequest = adRequest;
        this.cacheOnly = cacheOnly;
        this.timeout = timeout;
    }

    public final void startAuction(@NotNull AuctionListener auctionListener, @Nullable AdListener adListener) {
        Intrinsics.checkNotNullParameter((Object)auctionListener, (String)"auctionListener");
        Logger.INSTANCE.info("[Auction: " + (this.cacheOnly ? "Get Ad" : "Load Ad") + "] started.");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, auctionListener, adListener, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Auction this$0;
            final /* synthetic */ AuctionListener $auctionListener;
            final /* synthetic */ AdListener $adListener;
            {
                this.this$0 = $receiver;
                this.$auctionListener = $auctionListener;
                this.$adListener = $adListener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        var4_4 = Auction.access$getBidders$p(this.this$0);
                        var5_5 = this.this$0;
                        var6_6 = this.$adListener;
                        $i$f$map = false;
                        var8_10 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var15_19 = (Bidder)item$iv$iv;
                            var17_21 = destination$iv$iv;
                            $i$a$-map-Auction$startAuction$1$bidDeferreds$1 = false;
                            var17_21.add(BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuctionBid>, Object>((Auction)var5_5, (Bidder)bidder, (AdListener)var6_6, null){
                                int label;
                                final /* synthetic */ Auction this$0;
                                final /* synthetic */ Bidder $bidder;
                                final /* synthetic */ AdListener $adListener;
                                {
                                    this.this$0 = $receiver;
                                    this.$bidder = $bidder;
                                    this.$adListener = $adListener;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = Auction.access$fetchBid(this.this$0, this.$bidder, this.$adListener, Auction.access$getCacheOnly$p(this.this$0), (Continuation)this);
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super AuctionBid> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        bidDeferreds = (List)destination$iv$iv;
                        var5_5 = bidDeferreds;
                        var6_6 = this.this$0;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            bidder = (Deferred)item$iv$iv;
                            var17_21 = destination$iv$iv;
                            $i$a$-map-Auction$startAuction$1$winningBid$1 = false;
                            var17_21.add(BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuctionBid>, Object>((Auction)var6_6, (Deferred<AuctionBid>)deferred, null){
                                int label;
                                final /* synthetic */ Auction this$0;
                                final /* synthetic */ Deferred<AuctionBid> $deferred;
                                {
                                    this.this$0 = $receiver;
                                    this.$deferred = $deferred;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = TimeoutKt.withTimeoutOrNull((long)Auction.access$getTimeout$p(this.this$0), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuctionBid>, Object>(this.$deferred, null){
                                                int label;
                                                final /* synthetic */ Deferred<AuctionBid> $deferred;
                                                {
                                                    this.$deferred = $deferred;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object object) {
                                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            this.label = 1;
                                                            Object object3 = this.$deferred.await((Continuation)this);
                                                            if (object3 != object2) return object3;
                                                            return object2;
                                                        }
                                                        case 1: {
                                                            void $result;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object3 = $result;
                                                            return object3;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super AuctionBid> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super AuctionBid> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.label = 1;
                        v0 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                        if (v0 == var18_2) {
                            return var18_2;
                        }
                        ** GOTO lbl42
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl42:
                        // 2 sources

                        $this$maxByOrNull$iv = CollectionsKt.filterNotNull((Iterable)((Iterable)v0));
                        $i$f$maxByOrNull = false;
                        iterator$iv = $this$maxByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v1 = null;
                        } else {
                            maxElem$iv = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v1 = maxElem$iv;
                            } else {
                                it = (AuctionBid)maxElem$iv;
                                $i$a$-maxByOrNull-Auction$startAuction$1$winningBid$2 = false;
                                maxValue$iv = it.getEcpm();
                                do {
                                    e$iv = iterator$iv.next();
                                    it = (AuctionBid)e$iv;
                                    $i$a$-maxByOrNull-Auction$startAuction$1$winningBid$2 = false;
                                    v$iv = it.getEcpm();
                                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                    maxElem$iv = e$iv;
                                    maxValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v1 = maxElem$iv;
                            }
                        }
                        winningBid = v1;
                        if (winningBid != null) {
                            Logger.INSTANCE.info("[Auction: " + (Auction.access$getCacheOnly$p(this.this$0) != false ? "Get Ad" : "Load Ad") + "] completed. winner: (" + winningBid.getBidderName() + ", " + winningBid.getEcpm() + ", " + winningBid.getBidderPlacementId() + ')');
                            this.$auctionListener.onSuccess(winningBid);
                        } else {
                            Logger.INSTANCE.info("[Auction: " + (Auction.access$getCacheOnly$p(this.this$0) != false ? "Get Ad" : "Load Ad") + "] completed. No winning bids");
                            this.$auctionListener.onError("No bids received");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object fetchBid(Bidder bidder, AdListener adListener, boolean cacheOnly, Continuation<? super AuctionBid> $completion) {
        Continuation<? super AuctionBid> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        Ref.BooleanRef isResumed = new Ref.BooleanRef();
        if (!cacheOnly) {
            Logger.INSTANCE.info("[Auction: Load Ad] Fetching bid from bidder: " + bidder.getName() + ". bidderPlacementId: " + bidder.getBidderPlacementId());
        }
        MSPAd cachedAd = AdCache.INSTANCE.peakAd(bidder.getBidderPlacementId());
        if (cacheOnly || cachedAd != null) {
            Unit unit;
            MSPAd mSPAd = cachedAd;
            if (mSPAd != null) {
                MSPAd it = mSPAd;
                boolean bl2 = false;
                Logger.INSTANCE.info("[Auction: " + (cacheOnly ? "Get Ad" : "Load Ad") + "] Ads filled from cache: " + bidder.getName() + ". price: " + it.getAdInfo().get("price") + ". bidderPlacementId: " + bidder.getBidderPlacementId());
                String string = bidder.getName();
                String string2 = bidder.getBidderPlacementId();
                Object object = it.getAdInfo().get("price");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                Auction.fetchBid$lambda$5$safeResume(isResumed, (Continuation<? super AuctionBid>)continuation2, cacheOnly, new AuctionBid(string, string2, (Double)object, true));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                Auction $this$fetchBid_u24lambda_u245_u24lambda_u241 = this;
                boolean bl3 = false;
                Logger.INSTANCE.info("[Auction: Get Ad ] Ads missed from cache: " + bidder.getName() + ". bidderPlacementId: " + bidder.getBidderPlacementId());
                Auction.fetchBid$lambda$5$safeResume(isResumed, (Continuation<? super AuctionBid>)continuation2, cacheOnly, null);
            }
        } else {
            Unit unit;
            AdRequest adRequest = this.adRequest;
            if (adRequest != null) {
                AdRequest adRequest2 = adRequest;
                boolean bl4 = false;
                AdListener adListener2 = adListener;
                if (adListener2 != null) {
                    AdListener adListener3 = adListener2;
                    boolean bl5 = false;
                    bidder.requestBid(adRequest2, new AuctionBidListener(bidder, isResumed, (Continuation<? super AuctionBid>)continuation2, cacheOnly){
                        final /* synthetic */ Bidder $bidder;
                        final /* synthetic */ Ref.BooleanRef $isResumed;
                        final /* synthetic */ Continuation<AuctionBid> $continuation;
                        final /* synthetic */ boolean $cacheOnly;
                        {
                            this.$bidder = $bidder;
                            this.$isResumed = $isResumed;
                            this.$continuation = $continuation;
                            this.$cacheOnly = $cacheOnly;
                        }

                        public void onSuccess(@NotNull AuctionBid bid) {
                            Intrinsics.checkNotNullParameter((Object)bid, (String)"bid");
                            Logger.INSTANCE.info("[Auction] Ads filled from bidder: " + this.$bidder.getName() + ". bidderPlacementId: " + this.$bidder.getBidderPlacementId());
                            Auction.access$fetchBid$lambda$5$safeResume(this.$isResumed, this.$continuation, this.$cacheOnly, bid);
                        }

                        public void onError(@NotNull String error) {
                            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                            Logger.INSTANCE.info("[Auction] Ads No fill from bidder: " + this.$bidder.getName() + ". bidderPlacementId: " + this.$bidder.getBidderPlacementId());
                            Auction.access$fetchBid$lambda$5$safeResume(this.$isResumed, this.$continuation, this.$cacheOnly, null);
                        }
                    }, adListener3);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            } else {
                unit = null;
            }
            if (unit == null) {
                Auction $this$fetchBid_u24lambda_u245_u24lambda_u244 = this;
                boolean bl6 = false;
                Logger.INSTANCE.info("[Auction] adRequest or adListener is null. Bidder: " + bidder.getName() + ". bidderPlacementId: " + bidder.getBidderPlacementId());
                Auction.fetchBid$lambda$5$safeResume(isResumed, (Continuation<? super AuctionBid>)continuation2, cacheOnly, null);
            }
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private static final void fetchBid$lambda$5$safeResume(Ref.BooleanRef isResumed, Continuation<? super AuctionBid> $continuation, boolean $cacheOnly, AuctionBid value) {
        if (!isResumed.element) {
            isResumed.element = true;
            $continuation.resumeWith(Result.constructor-impl((Object)value));
        } else {
            Logger.INSTANCE.warning("[Auction: " + ($cacheOnly ? "Get Ad" : "Load Ad") + "] Attempted to resume continuation more than once. Ignoring.");
        }
    }

    public static final /* synthetic */ List access$getBidders$p(Auction $this) {
        return $this.bidders;
    }

    public static final /* synthetic */ boolean access$getCacheOnly$p(Auction $this) {
        return $this.cacheOnly;
    }

    public static final /* synthetic */ Object access$fetchBid(Auction $this, Bidder bidder, AdListener adListener, boolean cacheOnly, Continuation $completion) {
        return $this.fetchBid(bidder, adListener, cacheOnly, (Continuation<? super AuctionBid>)$completion);
    }

    public static final /* synthetic */ int access$getTimeout$p(Auction $this) {
        return $this.timeout;
    }

    public static final /* synthetic */ void access$fetchBid$lambda$5$safeResume(Ref.BooleanRef isResumed, Continuation $continuation, boolean $cacheOnly, AuctionBid value) {
        Auction.fetchBid$lambda$5$safeResume(isResumed, (Continuation<? super AuctionBid>)$continuation, $cacheOnly, value);
    }
}

