/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.debug.ui;

import ai.themsp.mspcore.R;
import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.particles.msp.debug.state.AdDebugItemUiState;
import com.particles.msp.debug.ui.TitledListViewHolder;
import com.particles.msp.util.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0016\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/particles/msp/debug/ui/TitledListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/particles/msp/debug/ui/TitledListViewHolder;", "itemList", "", "Lcom/particles/msp/debug/state/AdDebugItemUiState;", "(Ljava/util/List;)V", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "updateList", "list", "msp-core_mavenRelease"})
public final class TitledListAdapter
extends RecyclerView.Adapter<TitledListViewHolder> {
    @NotNull
    private List<AdDebugItemUiState> itemList;

    public TitledListAdapter(@NotNull List<AdDebugItemUiState> itemList) {
        Intrinsics.checkNotNullParameter(itemList, (String)"itemList");
        this.itemList = itemList;
    }

    @NotNull
    public TitledListViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.titled_list_view_item, parent, false);
        Intrinsics.checkNotNull((Object)convertView);
        return new TitledListViewHolder(convertView);
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public void onBindViewHolder(@NotNull TitledListViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        if (position < 0 || position >= this.itemList.size()) {
            Logger.INSTANCE.info("[Debugger] position out of bound in onBindViewHolder: " + position + " is out of bound [0, " + this.itemList.size() + ')');
            return;
        }
        AdDebugItemUiState model = this.itemList.get(position);
        holder.bind(model);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void updateList(@NotNull List<AdDebugItemUiState> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.itemList = list;
        this.notifyDataSetChanged();
    }
}

