package com.particles.msp.debug.datasource

import com.particles.msp.auction.AdConfigManager
import com.particles.msp.debug.models.AdDebugResource
import com.particles.msp.debug.AdDebugCategory
import com.particles.msp.debug.FACEBOOK
import com.particles.msp.debug.GOOGLE
import com.particles.msp.debug.HORIZONTAL
import com.particles.msp.debug.IMAGE
import com.particles.msp.debug.INTERSTITIAL
import com.particles.msp.debug.PUBMATIC
import com.particles.msp.debug.NATIVE
import com.particles.msp.debug.NO
import com.particles.msp.debug.NOVA
import com.particles.msp.debug.VERTICAL
import com.particles.msp.debug.VIDEO
import com.particles.msp.debug.YES

internal class AdDebugHardCodedDataSource : AdDebugDataSource {

    override suspend fun fetchAdDebugResources(category: AdDebugCategory): List<AdDebugResource>
        = when (category) {
            AdDebugCategory.NETWORK -> fetchAdDebugNetworkResources()
            AdDebugCategory.FORMAT -> fetchAdDebugFormatResources()
            AdDebugCategory.CREATIVE_TYPE -> fetchAdDebugCreativeTypeResources()
            AdDebugCategory.LAYOUT -> fetchAdDebugLayoutResources()
            AdDebugCategory.HIGH_ENGAGEMENT -> fetchAdDebugHighEngagementResources()
    }

    override suspend fun fetchPlacementIds(): List<String> {
        return AdConfigManager.getPlacementIds()
    }

    private fun fetchAdDebugNetworkResources(): List<AdDebugResource>
        = listOf(
            AdDebugResource(GOOGLE),
            AdDebugResource(FACEBOOK),
            AdDebugResource(NOVA, selected = true),
            AdDebugResource(PUBMATIC)
        )

    private fun fetchAdDebugFormatResources(): List<AdDebugResource>
        = listOf(
//            AdDebugResource(BANNER),
            AdDebugResource(NATIVE),
//            AdDebugResource(MULTI_FORMAT),
            AdDebugResource(INTERSTITIAL, selected = true),
        )

    private fun fetchAdDebugCreativeTypeResources(): List<AdDebugResource>
        = listOf(
            AdDebugResource(IMAGE),
            AdDebugResource(VIDEO, selected = true),
        )

    private fun fetchAdDebugLayoutResources(): List<AdDebugResource>
        = listOf(
            AdDebugResource(HORIZONTAL),
            AdDebugResource(VERTICAL, selected = true),
        )

    private fun fetchAdDebugHighEngagementResources(): List<AdDebugResource>
        = listOf(
            AdDebugResource(YES),
            AdDebugResource(NO, selected = true),
        )
}