/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.util;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.display.DisplayManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RequiresPermission;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.core.app.ActivityCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.particles.mes.android.MesTracker;
import com.particles.mes.android.data.AppSignal;
import com.particles.mes.android.data.ConnectionType;
import com.particles.mes.android.data.DeviceSignal;
import com.particles.mes.android.data.SdkSignal;
import com.particles.mes.protos.SdkPlatform;
import com.particles.msp.MSPManager;
import com.particles.msp.util.AdIdRepo;
import com.particles.msp.util.AppSetIdRepo;
import com.particles.msp.util.Logger;
import com.particles.msp.util.StorageStats;
import com.particles.msp.util.UserId;
import com.particles.msp.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.prebid.mobile.rendering.sdk.ManagersResolver;
import org.prebid.mobile.rendering.utils.helpers.AdIdManager;
import org.prebid.mobile.rendering.utils.helpers.AppInfoManager;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\t\u001a\u00020\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\r\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u0010\u0010\u001d\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013\u001a\u0006\u0010\u001f\u001a\u00020\u0001\u001a\u0012\u0010 \u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u001a\u0010\u0010!\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0006\u0010\"\u001a\u00020\u0001\u001a\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0001\u001a\u000e\u0010&\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010)\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010*\u001a\u00020+\u001a\u000e\u0010,\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010.\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010/\u001a\u00020\u0001\u001a\u000e\u00100\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u00101\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u00102\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u00104\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u00105\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00106\u001a\u00020\f\u001a$\u00107\u001a\u0002082\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00140:\u001a\u000e\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"USER_SIGNALS_PREFS", "", "getAppInstallTime", "", "context", "Landroid/content/Context;", "getAppSignal", "Lcom/particles/mes/android/data/AppSignal;", "getAvailableMemory", "getBatteryLevel", "", "getBatteryLevelInt", "", "getBatteryStatus", "getBidder", "bidJsonStr", "getBuckets", "", "ext", "", "", "getCellularConnectionType", "Lcom/particles/mes/android/data/ConnectionType;", "getConnectionType", "getCountry", "getDeviceSignal", "Lcom/particles/mes/android/data/DeviceSignal;", "(Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDeviceTimezone", "getFontSize", "getInferredCountry", "getIsInForeground", "getIsLowDataMode", "getIsLowPowerMode", "getLocale", "getMesTracker", "Lcom/particles/mes/android/MesTracker;", "mesHostUrl", "getOrientation", "getSDKSignal", "Lcom/particles/mes/android/data/SdkSignal;", "getSDKSignalUUID", "getStorageStats", "Lcom/particles/msp/util/StorageStats;", "getSystemBrightness", "getThemeStatus", "getThermalStatus", "getTimezone", "getTotalMemory", "getVolumeLevel", "isAppFirstLaunch", "", "isFreshInstall", "loadJSONFromRaw", "resourceId", "setBatteryStatusAndLevel", "", "customParams", "", "trackUrl", "url", "msp-core_mavenRelease"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/particles/msp/util/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,560:1\n1#2:561\n40#3,11:562\n40#3,11:573\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/particles/msp/util/UtilsKt\n*L\n532#1:562,11\n548#1:573,11\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final String USER_SIGNALS_PREFS = "msp_user_signals";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String loadJSONFromRaw(@NotNull Context context, int resourceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = context.getResources().openRawResource(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openRawResource(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    @NotNull
    public static final String getBidder(@NotNull String bidJsonStr) {
        Intrinsics.checkNotNullParameter((Object)bidJsonStr, (String)"bidJsonStr");
        String bidder = "";
        try {
            String string2 = new JSONObject(bidJsonStr).getJSONObject("ext").getJSONObject("prebid").getJSONObject("meta").getString("adaptercode");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            bidder = string2;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return bidder;
    }

    @NotNull
    public static final List<String> getBuckets(@Nullable Map<String, ? extends Object> ext) {
        List buckets;
        block3: {
            buckets = new ArrayList();
            try {
                Map<String, ? extends Object> map = ext;
                Object object = map != null ? map.get("msp_exp_bucket_info") : null;
                JSONObject jSONObject = object instanceof JSONObject ? (JSONObject)object : null;
                JSONObject jSONObject2 = jSONObject;
                if (jSONObject2 == null || (jSONObject2 = jSONObject2.optJSONArray("exp_bucket_list")) == null) break block3;
                JSONObject it = jSONObject2;
                boolean bl = false;
                int n = it.length();
                for (int i = 0; i < n; ++i) {
                    String string2;
                    String string3 = string2 = it.optString(i);
                    if (string3 == null) continue;
                    Intrinsics.checkNotNull((Object)string3);
                    String bucket = string2;
                    boolean bl2 = false;
                    if (!(((CharSequence)bucket).length() > 0)) continue;
                    buckets.add(bucket);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return buckets;
    }

    @Nullable
    public static final String getInferredCountry(@Nullable Map<String, ? extends Object> ext) {
        Map<String, ? extends Object> map = ext;
        Object object = map != null ? map.get("inferred_country") : null;
        return object instanceof String ? (String)object : null;
    }

    public static final void trackUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(url, null){
            int label;
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            URLConnection uRLConnection = new URL(this.$url).openConnection();
                            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                            connection.connect();
                            connection.getInputStream().close();
                            connection.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public static final MesTracker getMesTracker(@NotNull String mesHostUrl) {
        MesTracker mesTracker;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)mesHostUrl, (String)"mesHostUrl");
        String it = string3 = mesHostUrl;
        boolean bl = false;
        String string4 = string2 = ((CharSequence)it).length() > 0 ? string3 : null;
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            mesTracker = MesTracker.Companion.obtain(it);
        } else {
            mesTracker = null;
        }
        return mesTracker;
    }

    public static final long getAppInstallTime(@NotNull Context context) {
        long l;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            l = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException _) {
            l = 0L;
        }
        return l;
    }

    public static final long getAvailableMemory(@Nullable Context context) {
        ActivityManager.MemoryInfo memInfo;
        block1: {
            ActivityManager activityManager;
            Context context2 = context;
            Object object = context2 != null ? context2.getSystemService("activity") : null;
            ActivityManager activityManager2 = activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
            if (activityManager == null) {
                Logger.INSTANCE.info("getAvailableMemory: context is null or get ActivityManager failed.");
            }
            memInfo = new ActivityManager.MemoryInfo();
            ActivityManager activityManager3 = activityManager;
            if (activityManager3 == null) break block1;
            activityManager3.getMemoryInfo(memInfo);
        }
        return memInfo.availMem;
    }

    public static final long getTotalMemory(@NotNull Context context) {
        ActivityManager.MemoryInfo memInfo;
        block1: {
            ActivityManager activityManager;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSystemService("activity");
            ActivityManager activityManager2 = activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
            if (activityManager == null) {
                Logger.INSTANCE.info("getAvailableMemory: context is null or get ActivityManager failed.");
            }
            memInfo = new ActivityManager.MemoryInfo();
            ActivityManager activityManager3 = activityManager;
            if (activityManager3 == null) break block1;
            activityManager3.getMemoryInfo(memInfo);
        }
        return memInfo.totalMem;
    }

    @NotNull
    public static final StorageStats getStorageStats() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSizeLong();
        long totalBlocks = stat.getBlockCountLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        return new StorageStats(totalBlocks * blockSize, availableBlocks * blockSize);
    }

    @NotNull
    public static final String getDeviceTimezone() {
        TimeZone timeZone = TimeZone.getDefault();
        int offsetInMillis = timeZone.getOffset(System.currentTimeMillis());
        int hours = offsetInMillis / 3600000;
        int minutes = offsetInMillis % 3600000 / 60000;
        Locale locale = Locale.US;
        String string2 = "%+03d:%02d";
        Object[] objectArray = new Object[]{hours, Math.abs(minutes)};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public static final String getFontSize(@Nullable Context context) {
        String string2;
        Context context2 = context;
        if (context2 != null) {
            Context it = context2;
            boolean bl = false;
            float fontScale = it.getResources().getConfiguration().fontScale;
            string2 = fontScale == 1.0f ? "m" : (fontScale < 1.0f ? "s" : (fontScale > 1.0f ? "l" : "unknown"));
        } else {
            string2 = "unknown";
        }
        return string2;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @NotNull
    public static final String getIsLowDataMode(@Nullable Context context) {
        if (context == null) {
            Logger.INSTANCE.info("getIsLowDataMode: context is null");
            return "unknown";
        }
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            ConnectivityManager connectivityManager;
            Object object = context.getSystemService("connectivity");
            ConnectivityManager connectivityManager2 = connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
            if (connectivityManager == null) {
                Logger.INSTANCE.info("getIsLowDataMode: get ConnectivityManager failed");
                return "unknown";
            }
            return connectivityManager.isActiveNetworkMetered() ? "true" : "false";
        }
        Logger.INSTANCE.info("getIsLowDataMode: no permission of ACCESS_NETWORK_STATE");
        return "unknown";
    }

    @NotNull
    public static final String getIsLowPowerMode(@Nullable Context context) {
        PowerManager powerManager;
        if (context == null) {
            Logger.INSTANCE.info("getIsLowPowerMode: context is null");
            return "unknown";
        }
        Object object = context.getSystemService("power");
        PowerManager powerManager2 = powerManager = object instanceof PowerManager ? (PowerManager)object : null;
        if (powerManager == null) {
            Logger.INSTANCE.info("getIsLowPowerMode: get PowerManager failed");
            return "unknown";
        }
        return powerManager.isPowerSaveMode() ? "true" : "false";
    }

    public static final void setBatteryStatusAndLevel(@Nullable Context context, @NotNull Map<String, Object> customParams) {
        Intrinsics.checkNotNullParameter(customParams, (String)"customParams");
        if (context == null) {
            Logger.INSTANCE.info("getBatteryStatus: context is null");
            customParams.put("battery_level", "unknown");
            customParams.put("battery_status", "unknown");
        } else {
            BatteryManager batteryManager;
            Object object = context.getSystemService("batterymanager");
            BatteryManager batteryManager2 = batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
            if (batteryManager == null) {
                Logger.INSTANCE.info("getBatteryStatus: get BatteryManager failed");
                customParams.put("battery_level", "unknown");
                customParams.put("battery_status", "unknown");
            } else {
                int batteryCapacity = batteryManager.getIntProperty(4);
                Map<String, Object> map = customParams;
                Object object2 = "battery_level";
                String string2 = "%.2f";
                Object object3 = new Object[]{Float.valueOf((float)batteryCapacity / 100.0f)};
                String string3 = String.format(string2, Arrays.copyOf(object3, ((Object[])object3).length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                string2 = string3;
                map.put((String)object2, string2);
                if (Build.VERSION.SDK_INT >= 26) {
                    String string4;
                    int batteryStatus = batteryManager.getIntProperty(6);
                    object2 = customParams;
                    string2 = "battery_status";
                    switch (batteryStatus) {
                        case 2: {
                            string4 = "charging";
                            break;
                        }
                        case 3: {
                            string4 = "unplugged";
                            break;
                        }
                        case 5: {
                            string4 = "full";
                            break;
                        }
                        case 4: {
                            string4 = "unknown";
                            break;
                        }
                        case 1: {
                            string4 = "unknown";
                            break;
                        }
                        default: {
                            string4 = "unknown";
                        }
                    }
                    object3 = string4;
                    object2.put(string2, object3);
                } else {
                    customParams.put("battery_status", "unknown");
                }
            }
        }
    }

    @NotNull
    public static final String getBatteryStatus(@Nullable Context context) {
        String string2;
        if (context == null) {
            string2 = "unknown";
        } else {
            BatteryManager batteryManager;
            Object object = context.getSystemService("batterymanager");
            BatteryManager batteryManager2 = batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
            if (batteryManager == null) {
                string2 = "unknown";
            } else if (Build.VERSION.SDK_INT >= 26) {
                int batteryStatus = batteryManager.getIntProperty(6);
                switch (batteryStatus) {
                    case 2: {
                        string2 = "charging";
                        break;
                    }
                    case 3: {
                        string2 = "unplugged";
                        break;
                    }
                    case 5: {
                        string2 = "full";
                        break;
                    }
                    case 4: {
                        string2 = "unknown";
                        break;
                    }
                    case 1: {
                        string2 = "unknown";
                        break;
                    }
                    default: {
                        string2 = "unknown";
                        break;
                    }
                }
            } else {
                string2 = "unknown";
            }
        }
        return string2;
    }

    @NotNull
    public static final String getThermalStatus(@NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("power");
        PowerManager powerManager = object instanceof PowerManager ? (PowerManager)object : null;
        if (powerManager == null) {
            return "unknown";
        }
        PowerManager powerManager2 = powerManager;
        if (Build.VERSION.SDK_INT >= 29) {
            switch (powerManager2.getCurrentThermalStatus()) {
                case 0: {
                    string2 = "none";
                    break;
                }
                case 1: {
                    string2 = "light";
                    break;
                }
                case 2: {
                    string2 = "moderate";
                    break;
                }
                case 3: {
                    string2 = "severe";
                    break;
                }
                case 4: {
                    string2 = "critical";
                    break;
                }
                case 5: {
                    string2 = "emergency";
                    break;
                }
                case 6: {
                    string2 = "shutdown";
                    break;
                }
                default: {
                    string2 = "unknown";
                    break;
                }
            }
        } else {
            string2 = "unknown";
        }
        return string2;
    }

    @NotNull
    public static final String getThemeStatus(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int appMode = AppCompatDelegate.getDefaultNightMode();
        int currentMode = context.getResources().getConfiguration().uiMode & 0x30;
        return appMode == -1 ? "system" : (currentMode == 32 ? "dark" : (currentMode == 16 ? "light" : "unknown"));
    }

    public static final float getBatteryLevel(@Nullable Context context) {
        BatteryManager batteryManager;
        Object object = context != null ? context.getSystemService("batterymanager") : null;
        BatteryManager batteryManager2 = batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
        return batteryManager != null ? (float)batteryManager.getIntProperty(4) / 100.0f : 0.0f;
    }

    public static final int getBatteryLevelInt(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("batterymanager");
        BatteryManager batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
        return batteryManager != null ? batteryManager.getIntProperty(4) : -1;
    }

    public static final int getVolumeLevel(@NotNull Context context) {
        AudioManager audioManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("audio");
        AudioManager audioManager2 = audioManager = object instanceof AudioManager ? (AudioManager)object : null;
        return audioManager2 != null ? audioManager2.getStreamVolume(3) : -1;
    }

    public static final int getSystemBrightness(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            n = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            n = -1;
        }
        return n;
    }

    @NotNull
    public static final String getOrientation(@NotNull Context context) {
        String string2;
        Display display;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 30) {
            DisplayManager displayManager;
            object = context.getSystemService("display");
            DisplayManager displayManager2 = displayManager = object instanceof DisplayManager ? (DisplayManager)object : null;
            if (displayManager == null) {
                Logger.INSTANCE.info("getOrientation: get DisplayManager failed");
                return "unknown";
            }
            display = displayManager.getDisplay(0);
            if (display == null) {
                return "unknown";
            }
        } else {
            WindowManager windowManager;
            object = context.getSystemService("window");
            WindowManager windowManager2 = windowManager = object instanceof WindowManager ? (WindowManager)object : null;
            if (windowManager == null) {
                Logger.INSTANCE.info("getOrientation: get WindowManager failed");
                return "unknown";
            }
            display = windowManager.getDefaultDisplay();
            if (display == null) {
                return "unknown";
            }
        }
        Display display2 = display;
        int rotation = display2.getRotation();
        int orientation = context.getResources().getConfiguration().orientation;
        switch (rotation) {
            case 0: {
                if (orientation == 1) {
                    string2 = "portrait";
                    break;
                }
                string2 = "landscapeLeft";
                break;
            }
            case 1: {
                if (orientation == 2) {
                    string2 = "landscapeLeft";
                    break;
                }
                string2 = "portraitUpsideDown";
                break;
            }
            case 2: {
                if (orientation == 1) {
                    string2 = "portraitUpsideDown";
                    break;
                }
                string2 = "landscapeRight";
                break;
            }
            case 3: {
                if (orientation == 2) {
                    string2 = "landscapeRight";
                    break;
                }
                string2 = "portrait";
                break;
            }
            default: {
                string2 = "unknown";
            }
        }
        return string2;
    }

    @NotNull
    public static final String getIsInForeground() {
        boolean isForeground = ProcessLifecycleOwner.get().getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        Logger.INSTANCE.info("getIsInForeground: " + isForeground);
        return isForeground ? "true" : "false";
    }

    @NotNull
    public static final ConnectionType getCellularConnectionType(@NotNull Context context) {
        ConnectionType connectionType;
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("phone");
        TelephonyManager telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
        if (telephonyManager == null) {
            return ConnectionType.CONNECTION_TYPE_CELL_UNKNOWN;
        }
        TelephonyManager telephonyManager2 = telephonyManager;
        if (Build.VERSION.SDK_INT < 24) {
            return ConnectionType.CONNECTION_TYPE_CELL_UNKNOWN;
        }
        try {
            n = telephonyManager2.getDataNetworkType();
        }
        catch (SecurityException _) {
            return ConnectionType.CONNECTION_TYPE_CELL_UNKNOWN;
        }
        int type = n;
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                connectionType = ConnectionType.CONNECTION_TYPE_CELL_2G;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                connectionType = ConnectionType.CONNECTION_TYPE_CELL_3G;
                break;
            }
            case 13: {
                connectionType = ConnectionType.CONNECTION_TYPE_CELL_4G;
                break;
            }
            case 20: {
                connectionType = ConnectionType.CONNECTION_TYPE_CELL_5G;
                break;
            }
            default: {
                connectionType = ConnectionType.CONNECTION_TYPE_CELL_UNKNOWN;
            }
        }
        return connectionType;
    }

    @NotNull
    public static final ConnectionType getConnectionType(@NotNull Context context) {
        Network network;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager == null) {
            return ConnectionType.CONNECTION_TYPE_UNKNOWN;
        }
        ConnectivityManager connectivityManager2 = connectivityManager;
        if (Build.VERSION.SDK_INT >= 23) {
            network = connectivityManager2.getActiveNetwork();
            if (network == null) {
                return ConnectionType.CONNECTION_TYPE_UNKNOWN;
            }
        } else {
            return ConnectionType.CONNECTION_TYPE_UNKNOWN;
        }
        Network network2 = network;
        NetworkCapabilities networkCapabilities = connectivityManager2.getNetworkCapabilities(network2);
        if (networkCapabilities == null) {
            return ConnectionType.CONNECTION_TYPE_UNKNOWN;
        }
        NetworkCapabilities capabilities = networkCapabilities;
        return capabilities.hasTransport(1) ? ConnectionType.CONNECTION_TYPE_WIFI : (capabilities.hasTransport(3) ? ConnectionType.CONNECTION_TYPE_ETHERNET : (capabilities.hasTransport(0) ? UtilsKt.getCellularConnectionType(context) : ConnectionType.CONNECTION_TYPE_UNKNOWN));
    }

    @NotNull
    public static final String getCountry() {
        String string2 = Locale.getDefault().getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCountry(...)");
        return string2;
    }

    @NotNull
    public static final String getLocale() {
        String string2 = Locale.getDefault().toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLanguageTag(...)");
        return string2;
    }

    @NotNull
    public static final String getTimezone() {
        String string2 = TimeZone.getDefault().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getID(...)");
        return string2;
    }

    @NotNull
    public static final SdkSignal getSDKSignal(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Integer n = StringsKt.toIntOrNull((String)MSPManager.INSTANCE.getOrg());
        Integer n2 = StringsKt.toIntOrNull((String)MSPManager.INSTANCE.getApp());
        return new SdkSignal(n != null ? n : -1, n2 != null ? n2 : -1, UserId.INSTANCE.getCachedUserId(), "2.12.0", SdkPlatform.SDK_PLATFORM_ANDROID, 0L, UtilsKt.getSDKSignalUUID(context), 32, null);
    }

    @NotNull
    public static final AppSignal getAppSignal() {
        String string2;
        String string3;
        String string4 = AppInfoManager.getAppName();
        if (string4 == null) {
            string4 = "";
        }
        if ((string3 = AppInfoManager.getPackageName()) == null) {
            string3 = "";
        }
        if ((string2 = AppInfoManager.getAppVersion()) == null) {
            string2 = "";
        }
        return new AppSignal(string4, string3, string2, "", "", MSPManager.INSTANCE.getPpid());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getDeviceSignal(@NotNull Context var0, @NotNull Continuation<? super DeviceSignal> var1_1) {
        if (!(var1_1 instanceof getDeviceSignal.1)) ** GOTO lbl-1000
        var39_2 = var1_1;
        if ((var39_2.label & -2147483648) != 0) {
            var39_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                Object L$14;
                Object L$15;
                Object L$16;
                Object L$17;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                long J$0;
                long J$1;
                long J$2;
                long J$3;
                boolean Z$0;
                boolean Z$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UtilsKt.getDeviceSignal(null, (Continuation<? super DeviceSignal>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var75_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                storageStats = UtilsKt.getStorageStats();
                deviceManager = ManagersResolver.getInstance().getDeviceManager();
                v0 = Build.MANUFACTURER;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"MANUFACTURER");
                v1 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"MODEL");
                v2 = Build.VERSION.RELEASE;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"RELEASE");
                v3 = System.getProperty("os.version");
                if (v3 == null) {
                    v3 = "unknown";
                }
                v4 = deviceManager;
                v5 = v4 != null ? v4.getScreenWidth() : 0;
                v6 = deviceManager;
                v7 = v6 != null ? v6.getScreenHeight() : 0;
                v8 = UtilsKt.getOrientation(context);
                v9 = UtilsKt.getVolumeLevel(context);
                v10 = UtilsKt.getSystemBrightness(context);
                v11 = UtilsKt.getBatteryLevelInt(context);
                v12 = UtilsKt.getBatteryStatus(context);
                v13 = UtilsKt.getThermalStatus(context);
                v14 = UtilsKt.getTotalMemory(context);
                v15 = UtilsKt.getAvailableMemory(context);
                v16 = storageStats.getTotalStorageBytes();
                v17 = storageStats.getAvailableStorageBytes();
                v18 = Intrinsics.areEqual((Object)UtilsKt.getIsLowPowerMode(context), (Object)"true");
                v19 = Intrinsics.areEqual((Object)UtilsKt.getIsLowDataMode(context), (Object)"true");
                v20 = UtilsKt.getFontSize(context);
                v21 = UtilsKt.getThemeStatus(context);
                v22 = deviceManager;
                v23 = v22 != null ? v22.getCarrier() : null;
                if (v23 == null) {
                    v23 = "unknown";
                }
                v24 = deviceManager;
                v25 = v24 != null ? v24.getMccMnc() : null;
                if (v25 == null) {
                    v25 = "unknown";
                }
                v26 = UtilsKt.getConnectionType(context);
                v27 = UtilsKt.getCountry();
                v28 = UtilsKt.getTimezone();
                v29 = UtilsKt.getLocale();
                v30 = AppInfoManager.getUserAgent();
                Intrinsics.checkNotNullExpressionValue((Object)v30, (String)"getUserAgent(...)");
                var35_7 = v30;
                var34_8 = v29;
                var33_9 = v28;
                var32_10 = v27;
                var31_11 = v26;
                var30_12 = v25;
                var29_13 = v23;
                var28_14 = v21;
                var27_15 = v20;
                var26_16 = v19;
                var25_17 = v18;
                var23_18 = v17;
                var21_19 = v16;
                var19_20 = v15;
                var17_21 = v14;
                var16_22 = v13;
                var15_23 = v12;
                var14_24 = v11;
                var13_25 = v10;
                var12_26 = v9;
                var11_27 = v8;
                var10_28 = v7;
                var9_29 = v5;
                var8_30 = v3;
                var7_31 = v2;
                var6_32 = "Android";
                var5_33 = v1;
                var4_34 = v0;
                $continuation.L$0 = context;
                $continuation.L$1 = var4_34;
                $continuation.L$2 = var5_33;
                $continuation.L$3 = var6_32;
                $continuation.L$4 = var7_31;
                $continuation.L$5 = var8_30;
                $continuation.L$6 = var11_27;
                $continuation.L$7 = var15_23;
                $continuation.L$8 = var16_22;
                $continuation.L$9 = var27_15;
                $continuation.L$10 = var28_14;
                $continuation.L$11 = var29_13;
                $continuation.L$12 = var30_12;
                $continuation.L$13 = var31_11;
                $continuation.L$14 = var32_10;
                $continuation.L$15 = var33_9;
                $continuation.L$16 = var34_8;
                $continuation.L$17 = var35_7;
                $continuation.I$0 = var9_29;
                $continuation.I$1 = var10_28;
                $continuation.I$2 = var12_26;
                $continuation.I$3 = var13_25;
                $continuation.I$4 = var14_24;
                $continuation.J$0 = var17_21;
                $continuation.J$1 = var19_20;
                $continuation.J$2 = var21_19;
                $continuation.J$3 = var23_18;
                $continuation.Z$0 = var25_17;
                $continuation.Z$1 = var26_16;
                $continuation.label = 1;
                v31 = AdIdRepo.INSTANCE.get(context, (Continuation<? super String>)$continuation);
                if (v31 == var75_4) {
                    return var75_4;
                }
                ** GOTO lbl149
            }
            case 1: {
                var26_16 = $continuation.Z$1;
                var25_17 = $continuation.Z$0;
                var23_18 = $continuation.J$3;
                var21_19 = $continuation.J$2;
                var19_20 = $continuation.J$1;
                var17_21 = $continuation.J$0;
                var14_24 = $continuation.I$4;
                var13_25 = $continuation.I$3;
                var12_26 = $continuation.I$2;
                var10_28 = $continuation.I$1;
                var9_29 = $continuation.I$0;
                var35_7 = (String)$continuation.L$17;
                var34_8 = (String)$continuation.L$16;
                var33_9 = (String)$continuation.L$15;
                var32_10 = (String)$continuation.L$14;
                var31_11 = (ConnectionType)$continuation.L$13;
                var30_12 = (String)$continuation.L$12;
                var29_13 = (String)$continuation.L$11;
                var28_14 = (String)$continuation.L$10;
                var27_15 = (String)$continuation.L$9;
                var16_22 = (String)$continuation.L$8;
                var15_23 = (String)$continuation.L$7;
                var11_27 = (String)$continuation.L$6;
                var8_30 = (String)$continuation.L$5;
                var7_31 = (String)$continuation.L$4;
                var6_32 = (String)$continuation.L$3;
                var5_33 = (String)$continuation.L$2;
                var4_34 = (String)$continuation.L$1;
                context = (Context)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v31 = $result;
lbl149:
                // 2 sources

                var36_35 = v31;
                var36_35 = (String)var36_35;
                $continuation.L$0 = var4_34;
                $continuation.L$1 = var5_33;
                $continuation.L$2 = var6_32;
                $continuation.L$3 = var7_31;
                $continuation.L$4 = var8_30;
                $continuation.L$5 = var11_27;
                $continuation.L$6 = var15_23;
                $continuation.L$7 = var16_22;
                $continuation.L$8 = var27_15;
                $continuation.L$9 = var28_14;
                $continuation.L$10 = var29_13;
                $continuation.L$11 = var30_12;
                $continuation.L$12 = var31_11;
                $continuation.L$13 = var32_10;
                $continuation.L$14 = var33_9;
                $continuation.L$15 = var34_8;
                $continuation.L$16 = var35_7;
                $continuation.L$17 = var36_35;
                $continuation.I$0 = var9_29;
                $continuation.I$1 = var10_28;
                $continuation.I$2 = var12_26;
                $continuation.I$3 = var13_25;
                $continuation.I$4 = var14_24;
                $continuation.J$0 = var17_21;
                $continuation.J$1 = var19_20;
                $continuation.J$2 = var21_19;
                $continuation.J$3 = var23_18;
                $continuation.Z$0 = var25_17;
                $continuation.Z$1 = var26_16;
                $continuation.label = 2;
                v32 = AppSetIdRepo.INSTANCE.get(context, (Continuation<? super String>)$continuation);
                if (v32 == var75_4) {
                    return var75_4;
                }
                ** GOTO lbl217
            }
            case 2: {
                var26_16 = $continuation.Z$1;
                var25_17 = $continuation.Z$0;
                var23_18 = $continuation.J$3;
                var21_19 = $continuation.J$2;
                var19_20 = $continuation.J$1;
                var17_21 = $continuation.J$0;
                var14_24 = $continuation.I$4;
                var13_25 = $continuation.I$3;
                var12_26 = $continuation.I$2;
                var10_28 = $continuation.I$1;
                var9_29 = $continuation.I$0;
                var36_35 = (String)$continuation.L$17;
                var35_7 = (String)$continuation.L$16;
                var34_8 = (String)$continuation.L$15;
                var33_9 = (String)$continuation.L$14;
                var32_10 = (String)$continuation.L$13;
                var31_11 = (ConnectionType)$continuation.L$12;
                var30_12 = (String)$continuation.L$11;
                var29_13 = (String)$continuation.L$10;
                var28_14 = (String)$continuation.L$9;
                var27_15 = (String)$continuation.L$8;
                var16_22 = (String)$continuation.L$7;
                var15_23 = (String)$continuation.L$6;
                var11_27 = (String)$continuation.L$5;
                var8_30 = (String)$continuation.L$4;
                var7_31 = (String)$continuation.L$3;
                var6_32 = (String)$continuation.L$2;
                var5_33 = (String)$continuation.L$1;
                var4_34 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v32 = $result;
lbl217:
                // 2 sources

                var37_36 = v32;
                var40_37 = AdIdManager.isLimitAdTrackingEnabled();
                var41_38 = (String)var37_36;
                var42_39 = var36_35;
                var43_40 = var35_7;
                var44_41 = var34_8;
                var45_42 = var33_9;
                var46_43 = var32_10;
                var47_44 = var31_11;
                var48_45 = var30_12;
                var49_46 = var29_13;
                var50_47 = var28_14;
                var51_48 = var27_15;
                var52_49 = var26_16;
                var53_50 = var25_17;
                var54_51 = var23_18;
                var56_52 = var21_19;
                var58_53 = var19_20;
                var60_54 = var17_21;
                var62_55 = var16_22;
                var63_56 = var15_23;
                var64_57 = var14_24;
                var65_58 = var13_25;
                var66_59 = var12_26;
                var67_60 = var11_27;
                var68_61 = var10_28;
                var69_62 = var9_29;
                var70_63 = var8_30;
                var71_64 = var7_31;
                var72_65 = var6_32;
                var73_66 = var5_33;
                var74_67 = var4_34;
                return new DeviceSignal(var74_67, var73_66, var72_65, var71_64, var70_63, var69_62, var68_61, var67_60, var66_59, var65_58, var64_57, var63_56, var62_55, var60_54, var58_53, var56_52, var54_51, var53_50 != false, var52_49 != false, var51_48, var50_47, var49_46, var48_45, var47_44, var46_43, var45_42, var44_41, var43_40, (String)var42_39, var41_38, var40_37 != false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final boolean isAppFirstLaunch(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String keyFirstLaunch = "first_launch";
        SharedPreferences prefs = context.getSharedPreferences(USER_SIGNALS_PREFS, 0);
        boolean firstLaunch = prefs.getBoolean(keyFirstLaunch, true);
        if (firstLaunch) {
            SharedPreferences.Editor editor$iv;
            Intrinsics.checkNotNull((Object)prefs);
            SharedPreferences $this$edit$iv = prefs;
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$isAppFirstLaunch_u24lambda_u246 = editor;
            boolean bl = false;
            $this$isAppFirstLaunch_u24lambda_u246.putBoolean(keyFirstLaunch, false);
            editor$iv.apply();
        }
        boolean isFreshInstall = UtilsKt.isFreshInstall(context);
        Logger.INSTANCE.info("User signals: is first launch: " + firstLaunch + ". is fresh install: " + isFreshInstall);
        return isFreshInstall && firstLaunch;
    }

    @NotNull
    public static final String getSDKSignalUUID(@NotNull Context context) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String keyUUID = "device_signal_uuid";
        SharedPreferences prefs = context.getSharedPreferences(USER_SIGNALS_PREFS, 0);
        String string2 = prefs.getString(keyUUID, null);
        if (string2 != null) {
            String existing = string2;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)existing)) {
                return existing;
            }
        }
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String newId = string3;
        Intrinsics.checkNotNull((Object)prefs);
        SharedPreferences $this$edit$iv = prefs;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$getSDKSignalUUID_u24lambda_u248 = editor;
        boolean bl = false;
        $this$getSDKSignalUUID_u24lambda_u248.putString(keyUUID, newId);
        editor$iv.apply();
        return newId;
    }

    public static final boolean isFreshInstall(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            bl = info.firstInstallTime == info.lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }
}

