/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.auction;

import android.content.Context;
import com.particles.msp.adapter.InitializationParameters;
import com.particles.msp.auction.AdConfig;
import com.particles.msp.auction.AdConfigApi;
import com.particles.msp.auction.AdConfigManager;
import com.particles.msp.auction.AdConfigRequest;
import com.particles.msp.auction.AdConfigResponse;
import com.particles.msp.auction.BidderInfo;
import com.particles.msp.auction.Placement;
import com.particles.msp.util.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J)\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000eJ\u0016\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$J\n\u0010%\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\fH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\b\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lcom/particles/msp/auction/AdConfigManager;", "", "()V", "api", "Lcom/particles/msp/auction/AdConfigApi;", "getApi", "()Lcom/particles/msp/auction/AdConfigApi;", "api$delegate", "Lkotlin/Lazy;", "appContext", "Landroid/content/Context;", "cachedAdConfig", "Lcom/particles/msp/auction/AdConfig;", "configFileName", "", "jsonParser", "Lkotlinx/serialization/json/Json;", "retrofit", "Lretrofit2/Retrofit;", "getRetrofit", "()Lretrofit2/Retrofit;", "retrofit$delegate", "defaultAdConfig", "Lcom/particles/msp/auction/Placement;", "placementId", "fetchAdConfigFromServer", "", "appId", "", "orgId", "prebidApiKey", "(IILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAdConfig", "initialize", "context", "initParams", "Lcom/particles/msp/adapter/InitializationParameters;", "loadConfigFromLocalStorage", "saveConfigToLocalStorage", "adConfig", "msp-core_mavenRelease"})
@SourceDebugExtension(value={"SMAP\nAdConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdConfigManager.kt\ncom/particles/msp/auction/AdConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,125:1\n1#2:126\n113#3:127\n96#4:128\n*S KotlinDebug\n*F\n+ 1 AdConfigManager.kt\ncom/particles/msp/auction/AdConfigManager\n*L\n106#1:127\n113#1:128\n*E\n"})
public final class AdConfigManager {
    @NotNull
    public static final AdConfigManager INSTANCE = new AdConfigManager();
    @NotNull
    private static final Lazy retrofit$delegate = LazyKt.lazy((Function0)retrofit.2.INSTANCE);
    @NotNull
    private static final Lazy api$delegate = LazyKt.lazy((Function0)api.2.INSTANCE);
    private static Context appContext;
    @NotNull
    private static final Json jsonParser;
    @Nullable
    private static volatile AdConfig cachedAdConfig;
    @NotNull
    private static final String configFileName = "msp_ad_config.json";

    private AdConfigManager() {
    }

    private final Retrofit getRetrofit() {
        Lazy lazy = retrofit$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Retrofit)object;
    }

    private final AdConfigApi getApi() {
        Lazy lazy = api$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (AdConfigApi)object;
    }

    public final void initialize(@NotNull Context context, @NotNull InitializationParameters initParams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initParams, (String)"initParams");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        appContext = context2;
        cachedAdConfig = this.loadConfigFromLocalStorage();
        Logger.INSTANCE.info("ad config loaded from local file: " + cachedAdConfig);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(initParams, null){
            int label;
            final /* synthetic */ InitializationParameters $initParams;
            {
                this.$initParams = $initParams;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Logger.INSTANCE.info("Fetching ad config from remote server....");
                        this.label = 1;
                        Object object3 = AdConfigManager.access$fetchAdConfigFromServer(AdConfigManager.INSTANCE, this.$initParams.getAppId(), this.$initParams.getOrgId(), this.$initParams.getPrebidAPIKey(), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object fetchAdConfigFromServer(int appId, int orgId, String prebidApiKey, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(appId, orgId, prebidApiKey, null){
            int label;
            final /* synthetic */ int $appId;
            final /* synthetic */ int $orgId;
            final /* synthetic */ String $prebidApiKey;
            {
                this.$appId = $appId;
                this.$orgId = $orgId;
                this.$prebidApiKey = $prebidApiKey;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        request = new AdConfigRequest(this.$appId, this.$orgId, this.$prebidApiKey);
                        this.label = 1;
                        v0 = AdConfigManager.access$getApi(AdConfigManager.INSTANCE).fetchAdConfig(request, (Continuation<? super AdConfigResponse>)((Continuation)this));
                        ** if (v0 != var10_2) goto lbl12
lbl11:
                        // 1 sources

                        return var10_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            if ((response = (AdConfigResponse)v0).getCode() == 0) {
                                v1 = response.getAd_config_settings();
                                if (v1 != null) {
                                    settings = v1;
                                    $i$a$-let-AdConfigManager$fetchAdConfigFromServer$2$1 = false;
                                    Logger.INSTANCE.info("Ad config returned from remote server: " + settings.getAd_config());
                                    var6_8 = AdConfigManager.access$getJsonParser$p();
                                    string$iv = settings.getAd_config();
                                    $i$f$decodeFromString = false;
                                    this_$iv.getSerializersModule();
                                    adConfig = (AdConfig)this_$iv.decodeFromString((DeserializationStrategy)AdConfig.Companion.serializer(), string$iv);
                                    AdConfigManager.access$saveConfigToLocalStorage(AdConfigManager.INSTANCE, adConfig);
                                    AdConfigManager.access$setCachedAdConfig$p(adConfig);
                                    v2 = Unit.INSTANCE;
                                } else {
                                    v2 = null;
                                }
                                if (v2 == null) {
                                    Logger.INSTANCE.error("Ad Config settings are null.");
                                }
                            } else {
                                Logger.INSTANCE.error("Failed to fetch ad config: " + response.getMessage());
                            }
                        }
                        catch (Exception e) {
                            Logger.INSTANCE.error("Exception occurred: " + e.getMessage());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Placement getAdConfig(@NotNull String placementId) {
        Object object;
        block5: {
            block4: {
                Object v1;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)placementId, (String)"placementId");
                    object = cachedAdConfig;
                    if (object == null || (object = ((AdConfig)object).getPlacements()) == null) break block4;
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        Placement it = (Placement)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getPlacementId(), (Object)placementId)) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                if ((object = (Placement)v1) != null) break block5;
            }
            object = this.defaultAdConfig(placementId);
        }
        return object;
    }

    private final Placement defaultAdConfig(String placementId) {
        return new Placement(placementId, 8000, CollectionsKt.listOf((Object)new BidderInfo("msp", null, placementId, null, 10, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveConfigToLocalStorage(AdConfig adConfig) {
        Logger.INSTANCE.info("Save ad config returned from remote server to local file: " + adConfig);
        StringFormat $this$encodeToString$iv = (StringFormat)jsonParser;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String configJson = $this$encodeToString$iv.encodeToString((SerializationStrategy)AdConfig.Companion.serializer(), (Object)adConfig);
        Context context = appContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
            context = null;
        }
        Closeable closeable = context.openFileOutput(configFileName, 0);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            byte[] byArray = configJson.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            it.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AdConfig loadConfigFromLocalStorage() {
        AdConfig adConfig;
        try {
            Context context = appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
                context = null;
            }
            FileInputStream fileInputStream = context.openFileInput(configFileName);
            Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"openFileInput(...)");
            Closeable closeable = fileInputStream;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            object = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object configJson = object2;
            Json this_$iv = jsonParser;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            adConfig = (AdConfig)this_$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable(AdConfig.Companion.serializer()), (String)configJson);
        }
        catch (Exception e) {
            adConfig = null;
        }
        return adConfig;
    }

    public static final /* synthetic */ Object access$fetchAdConfigFromServer(AdConfigManager $this, int appId, int orgId, String prebidApiKey, Continuation $completion) {
        return $this.fetchAdConfigFromServer(appId, orgId, prebidApiKey, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ AdConfigApi access$getApi(AdConfigManager $this) {
        return $this.getApi();
    }

    public static final /* synthetic */ Json access$getJsonParser$p() {
        return jsonParser;
    }

    public static final /* synthetic */ void access$saveConfigToLocalStorage(AdConfigManager $this, AdConfig adConfig) {
        $this.saveConfigToLocalStorage(adConfig);
    }

    public static final /* synthetic */ void access$setCachedAdConfig$p(AdConfig adConfig) {
        cachedAdConfig = adConfig;
    }

    public static final /* synthetic */ Retrofit access$getRetrofit(AdConfigManager $this) {
        return $this.getRetrofit();
    }

    static {
        jsonParser = JsonKt.Json$default(null, (Function1)jsonParser.1.INSTANCE, (int)1, null);
    }
}

