package com.particles.msp.api

import com.particles.msp.adapter.AdNetworkAdapter

abstract class MSPAd(protected val adNetworkAdapter: AdNetworkAdapter) {
    val adInfo: MutableMap<String, Any> = mutableMapOf()

    fun destroy() {
        adNetworkAdapter.destroyAd()
    }

    fun sendHideAdEvent(
        reason: String,
        areaScreenshot: ByteArray? = null,
        fullScreenshot: ByteArray? = null,
    ) {
        adNetworkAdapter.sendHideAdEvent(reason, areaScreenshot, fullScreenshot)
    }

    fun sendReportAdEvent(
        reason: String, description: String? = null,
        areaScreenshot: ByteArray? = null,
        fullScreenshot: ByteArray? = null,
    ) {
        adNetworkAdapter.sendReportAdEvent(reason, description, areaScreenshot, fullScreenshot)
    }
}