package com.particles.msp.auction
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class AdConfig(
    val orgId: Int,
    val appId: Int,
    val bundle: String,
    val placements: List<Placement>
)

@Serializable
data class Placement(
    @SerialName("placement_id") val placementId: String,
    @SerialName("auction_timeout") val auctionTimeout: Int,
    val bidders: List<BidderInfo>
)

@Serializable
data class BidderInfo(
    val name: String,
    @SerialName("bidder_format") val bidderFormat: String? = null,
    @SerialName("bidder_placement_id") val bidderPlacementId: String,
    val price: Double? = null // Nullable, since not all bidders have a price
)