package com.particles.msp.debug.ui

import ai.themsp.mspcore.R
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.particles.msp.debug.state.AdDebugItemUiState

internal class TitledListViewHolder(
    private val convertView: View,
) : RecyclerView.ViewHolder(convertView) {

    private val tvContent: TextView = convertView.findViewById(R.id.item_text)

    private val icSelect: ImageView = convertView.findViewById(R.id.item_selected)

    init {
        icSelect.visibility = View.INVISIBLE
    }

    fun bind(model: AdDebugItemUiState) {
        model.run {
            tvContent.text = text
            icSelect.visibility = if (selected) View.VISIBLE else View.INVISIBLE
            convertView.setOnClickListener {
                model.onSelect(text)
            }
        }
    }
}