package com.particles.msp.util

import android.view.View

class AdViewHelper(
    private val view: View,
    private var onImpression: (() -> Unit)? = null,
) {

    private val onAttachStateChangeListener = object : View.OnAttachStateChangeListener {
        override fun onViewAttachedToWindow(v: View) {
            visibilityTracker.startTracking()
        }

        override fun onViewDetachedFromWindow(v: View) {
            visibilityTracker.stopTracking()
        }
    }

    init {
        if (view.isAttachedToWindow) {
            onAttachStateChangeListener.onViewAttachedToWindow(view)
        }
        view.addOnAttachStateChangeListener(onAttachStateChangeListener)
    }

    private val visibilityTracker = VisibilityTracker(view) { visiblePixels, totalPixels ->
        if (visiblePixels > 0) {
            onImpression?.invoke()
            onImpression = null
        }
    }
}