/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.auction;

import com.particles.msp.AdNetworkAdapterProvider;
import com.particles.msp.MSPManager;
import com.particles.msp.adapter.AdNetwork;
import com.particles.msp.adapter.AdNetworkAdapter;
import com.particles.msp.api.AdFormat;
import com.particles.msp.api.AdListener;
import com.particles.msp.api.AdRequest;
import com.particles.msp.auction.AuctionBidListener;
import com.particles.msp.auction.Bidder;
import com.particles.msp.auction.BidderInfo;
import com.particles.msp.util.Logger;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/particles/msp/auction/DefaultBidder;", "Lcom/particles/msp/auction/Bidder;", "bidderInfo", "Lcom/particles/msp/auction/BidderInfo;", "(Lcom/particles/msp/auction/BidderInfo;)V", "network", "Lcom/particles/msp/adapter/AdNetwork;", "requestBid", "", "adRequest", "Lcom/particles/msp/api/AdRequest;", "bidListener", "Lcom/particles/msp/auction/AuctionBidListener;", "adListener", "Lcom/particles/msp/api/AdListener;", "msp-core_mavenRelease"})
@SourceDebugExtension(value={"SMAP\nDefaultBidder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultBidder.kt\ncom/particles/msp/auction/DefaultBidder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n288#2,2:43\n*S KotlinDebug\n*F\n+ 1 DefaultBidder.kt\ncom/particles/msp/auction/DefaultBidder\n*L\n12#1:43,2\n*E\n"})
public final class DefaultBidder
extends Bidder {
    @NotNull
    private final BidderInfo bidderInfo;
    @Nullable
    private final AdNetwork network;

    /*
     * WARNING - void declaration
     */
    public DefaultBidder(@NotNull BidderInfo bidderInfo) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)bidderInfo, (String)"bidderInfo");
            super(bidderInfo);
            this.bidderInfo = bidderInfo;
            Iterable iterable = (Iterable)AdNetwork.getEntries();
            DefaultBidder defaultBidder = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AdNetwork it = (AdNetwork)((Object)element$iv);
                boolean bl = false;
                if (!StringsKt.equals((String)it.name(), (String)this.bidderInfo.getName(), (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        defaultBidder.network = v0;
    }

    @Override
    public void requestBid(@NotNull AdRequest adRequest, @NotNull AuctionBidListener bidListener, @NotNull AdListener adListener) {
        AdRequest adRequest2;
        AdNetworkAdapter adapter;
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        Intrinsics.checkNotNullParameter((Object)bidListener, (String)"bidListener");
        Intrinsics.checkNotNullParameter((Object)adListener, (String)"adListener");
        if (this.network == null) {
            Logger.INSTANCE.info("[DefaultBidder] cannot find the ad network for bidder: " + this.bidderInfo.getName());
            bidListener.onError("cannot find the ad network for bidder: " + this.bidderInfo.getName());
            return;
        }
        AdNetworkAdapterProvider adNetworkAdapterProvider = MSPManager.INSTANCE.getAdNetworkAdapterProvider();
        AdNetworkAdapter adNetworkAdapter = adapter = adNetworkAdapterProvider != null ? adNetworkAdapterProvider.getAdNetworkAdapter(this.network) : null;
        if (adapter == null) {
            Logger.INSTANCE.info("[DefaultBidder] ad network adapter is null for network: " + (Object)((Object)this.network));
            bidListener.onError("ad network adapter is null for network: " + (Object)((Object)this.network));
            return;
        }
        if (adRequest.getAdFormat() == AdFormat.MULTI_FORMAT) {
            String string;
            String string2;
            String string3 = this.bidderInfo.getBidderFormat();
            if (string3 != null) {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            } else {
                string2 = string = null;
            }
            adRequest2 = Intrinsics.areEqual((Object)string, (Object)"banner") ? AdRequest.copy$default(adRequest, null, null, null, null, null, null, AdFormat.BANNER, null, null, null, null, 1983, null) : (Intrinsics.areEqual((Object)string, (Object)"native") ? AdRequest.copy$default(adRequest, null, null, null, null, null, null, AdFormat.NATIVE, null, null, null, null, 1983, null) : adRequest);
        } else {
            adRequest2 = adRequest;
        }
        AdRequest newAdRequest = adRequest2;
        Logger.INSTANCE.info("[Bidder: " + (Object)((Object)this.network) + "] send bid request for bidderPlacementId: " + this.getBidderPlacementId());
        adapter.loadAdCreative(null, bidListener, adRequest.getContext(), newAdRequest, adListener, this.getBidderPlacementId(), this.bidderInfo);
    }
}

