package com.particles.msp.debug.ui

import ai.themsp.mspcore.R
import android.annotation.SuppressLint
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.particles.msp.debug.state.AdDebugItemUiState
import com.particles.msp.util.Logger

internal class TitledListAdapter(
    private var itemList: List<AdDebugItemUiState>,
): RecyclerView.Adapter<TitledListViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): TitledListViewHolder {
        val convertView = LayoutInflater.from(parent.context).inflate(R.layout.titled_list_view_item, parent, false)
        return TitledListViewHolder(convertView)
    }

    override fun getItemCount(): Int = itemList.size

    override fun onBindViewHolder(holder: TitledListViewHolder, position: Int) {
        if (position < 0 || position >= itemList.size) {
            Logger.info("[Debugger] position out of bound in onBindViewHolder: $position is out of bound [0, ${itemList.size})")
            return
        }

        val model = itemList[position]
        holder.bind(model)
    }

    @SuppressLint("NotifyDataSetChanged")
    fun updateList(list: List<AdDebugItemUiState>) {
        itemList = list
        notifyDataSetChanged()
    }
}