package com.particles.msp.util

import android.content.Context
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import org.json.JSONException
import org.json.JSONObject
import java.net.HttpURLConnection
import java.net.URL

fun loadJSONFromRaw(context: Context, resourceId: Int): String {
    return context.resources.openRawResource(resourceId).bufferedReader().use { it.readText() }
}

fun getBidder(bidJsonStr: String): String {
    var bidder = ""
    try {
        bidder = JSONObject(bidJsonStr).getJSONObject("ext").getJSONObject("prebid").getJSONObject("meta")
            .getString("adaptercode")
    } catch (ignored: JSONException) {}
    return bidder
}

fun getBuckets(ext: Map<String, Any>?) : List<String> {
    val buckets = mutableListOf<String>()
    try {
        (ext?.get("msp_exp_bucket_info") as? JSONObject)?.optJSONArray("exp_bucket_list")?.let {
            for (i in 0 until it.length()) {
                it.optString(i)?.let { bucket ->
                    if (bucket.isNotEmpty()) {
                        buckets.add(bucket)
                    }
                }
            }
        }
    } catch (_: JSONException) {}
    return buckets
}

fun trackUrl(url: String) {
    CoroutineScope(Dispatchers.IO).launch {
        try {
            val connection = URL(url).openConnection() as HttpURLConnection
            connection.connect()
            connection.inputStream.close()
            connection.disconnect()
        } catch (_: Exception) {
        }
    }
}
