/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.debug.ui;

import ai.themsp.mspcore.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.particles.msp.debug.state.AdDebugItemUiState;
import com.particles.msp.debug.ui.TitledListAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/particles/msp/debug/ui/TitledListView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "defStyleRes", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "adapter", "Lcom/particles/msp/debug/ui/TitledListAdapter;", "insetDivider", "Landroid/graphics/drawable/InsetDrawable;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "tvTitle", "Landroid/widget/TextView;", "handleCustomAttrs", "", "setList", "list", "", "Lcom/particles/msp/debug/state/AdDebugItemUiState;", "msp-core_mavenRelease"})
@SourceDebugExtension(value={"SMAP\nTitledListView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TitledListView.kt\ncom/particles/msp/debug/ui/TitledListView\n+ 2 Context.kt\nandroidx/core/content/ContextKt\n+ 3 ColorDrawable.kt\nandroidx/core/graphics/drawable/ColorDrawableKt\n*L\n1#1,67:1\n55#2,5:68\n60#2:74\n27#3:73\n*S KotlinDebug\n*F\n+ 1 TitledListView.kt\ncom/particles/msp/debug/ui/TitledListView\n*L\n53#1:68,5\n53#1:74\n57#1:73\n*E\n"})
public final class TitledListView
extends LinearLayout {
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private final TextView tvTitle;
    private InsetDrawable insetDivider;
    @NotNull
    private final TitledListAdapter adapter;

    @JvmOverloads
    public TitledListView(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, defStyleRes);
        LayoutInflater.from((Context)context).inflate(R.layout.titled_list_view, (ViewGroup)this, true);
        View view = this.findViewById(R.id.titled_list_view_title);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.tvTitle = (TextView)view;
        View view2 = this.findViewById(R.id.titled_list_view_recycler);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.recyclerView = (RecyclerView)view2;
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context){

            public boolean canScrollVertically() {
                return false;
            }
        });
        this.adapter = new TitledListAdapter(CollectionsKt.emptyList());
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.handleCustomAttrs(attributeSet);
        DividerItemDecoration itemDecoration = new DividerItemDecoration(context, 1);
        InsetDrawable insetDrawable = this.insetDivider;
        if (insetDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"insetDivider");
            insetDrawable = null;
        }
        itemDecoration.setDrawable((Drawable)insetDrawable);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
    }

    public /* synthetic */ TitledListView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleCustomAttrs(AttributeSet attributeSet) {
        void $this$withStyledAttributes$iv;
        TypedArray typedArray;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Context context2 = context;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.TitledListView, (String)"TitledListView");
        int[] attrs$iv = R.styleable.TitledListView;
        int defStyleAttr$iv = 0;
        int defStyleRes$iv = 0;
        boolean $i$f$withStyledAttributes = false;
        TypedArray $this$handleCustomAttrs_u24lambda_u240 = typedArray = $this$withStyledAttributes$iv.obtainStyledAttributes(attributeSet, attrs$iv, defStyleAttr$iv, defStyleRes$iv);
        boolean bl = false;
        String title = $this$handleCustomAttrs_u24lambda_u240.getString(R.styleable.TitledListView_title);
        this.tvTitle.setText((CharSequence)title);
        int $this$toDrawable$iv = $this$handleCustomAttrs_u24lambda_u240.getResources().getColor(R.color.divider_color);
        boolean $i$f$toDrawable = false;
        ColorDrawable divider = new ColorDrawable($this$toDrawable$iv);
        int inset = $this$handleCustomAttrs_u24lambda_u240.getResources().getDimensionPixelOffset(R.dimen.divider_inset);
        this.insetDivider = new InsetDrawable((Drawable)divider, inset, 0, 0, 0);
        typedArray.recycle();
    }

    public final void setList(@NotNull List<AdDebugItemUiState> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.adapter.updateList(list);
    }

    @JvmOverloads
    public TitledListView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public TitledListView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

