/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.util;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import com.particles.msp.util.VisibilityTracker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006*\u0001\u0015\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00126\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\rH\u0002J\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/particles/msp/util/VisibilityTracker;", "", "view", "Landroid/view/View;", "handler", "Landroid/os/Handler;", "onVisibilityChanged", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "visiblePixels", "totalPixels", "", "(Landroid/view/View;Landroid/os/Handler;Lkotlin/jvm/functions/Function2;)V", "isTracking", "", "isVisibilityScheduled", "onPreDrawListener", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "visibilityRunnable", "com/particles/msp/util/VisibilityTracker$visibilityRunnable$1", "Lcom/particles/msp/util/VisibilityTracker$visibilityRunnable$1;", "scheduleVisibilityCheck", "startTracking", "stopTracking", "msp-core_mavenRelease"})
public final class VisibilityTracker {
    @NotNull
    private final View view;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Function2<Long, Long, Unit> onVisibilityChanged;
    private boolean isTracking;
    private boolean isVisibilityScheduled;
    @NotNull
    private final ViewTreeObserver.OnPreDrawListener onPreDrawListener;
    @NotNull
    private final visibilityRunnable.1 visibilityRunnable;

    public VisibilityTracker(@NotNull View view, @NotNull Handler handler, @NotNull Function2<? super Long, ? super Long, Unit> onVisibilityChanged) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(onVisibilityChanged, (String)"onVisibilityChanged");
        this.view = view;
        this.handler = handler;
        this.onVisibilityChanged = onVisibilityChanged;
        this.onPreDrawListener = () -> VisibilityTracker.onPreDrawListener$lambda$0(this);
        this.visibilityRunnable = new Runnable(this){
            @NotNull
            private final Rect tempRect;
            private long lastVisiblePixels;
            private long lastTotalPixels;
            final /* synthetic */ VisibilityTracker this$0;
            {
                this.this$0 = $receiver;
                this.tempRect = new Rect();
            }

            public void run() {
                VisibilityTracker.access$setVisibilityScheduled$p(this.this$0, false);
                if (!VisibilityTracker.access$getView$p(this.this$0).isShown() || VisibilityTracker.access$getView$p(this.this$0).getWindowVisibility() != 0 || !VisibilityTracker.access$getView$p(this.this$0).getGlobalVisibleRect(this.tempRect)) {
                    this.tempRect.setEmpty();
                }
                long visiblePixels = (long)this.tempRect.width() * (long)this.tempRect.height();
                long totalPixels = (long)VisibilityTracker.access$getView$p(this.this$0).getWidth() * (long)VisibilityTracker.access$getView$p(this.this$0).getHeight();
                if (visiblePixels != this.lastVisiblePixels || totalPixels != this.lastTotalPixels) {
                    VisibilityTracker.access$getOnVisibilityChanged$p(this.this$0).invoke((Object)visiblePixels, (Object)totalPixels);
                }
                this.lastVisiblePixels = visiblePixels;
                this.lastTotalPixels = totalPixels;
            }
        };
    }

    public /* synthetic */ VisibilityTracker(View view, Handler handler, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            handler = new Handler(Looper.getMainLooper());
        }
        this(view, handler, (Function2<? super Long, ? super Long, Unit>)function2);
    }

    public final void startTracking() {
        if (!this.isTracking) {
            this.isTracking = true;
            ViewTreeObserver observer = this.view.getViewTreeObserver();
            if (observer != null && observer.isAlive()) {
                observer.addOnPreDrawListener(this.onPreDrawListener);
            }
            this.scheduleVisibilityCheck();
        }
    }

    public final void stopTracking() {
        if (this.isTracking) {
            this.isTracking = false;
            ViewTreeObserver observer = this.view.getViewTreeObserver();
            if (observer != null && observer.isAlive()) {
                observer.removeOnPreDrawListener(this.onPreDrawListener);
            }
            this.handler.removeCallbacks((Runnable)this.visibilityRunnable);
            this.isVisibilityScheduled = false;
        }
    }

    private final void scheduleVisibilityCheck() {
        if (this.isVisibilityScheduled) {
            return;
        }
        this.isVisibilityScheduled = true;
        this.handler.postDelayed((Runnable)this.visibilityRunnable, 100L);
    }

    private static final boolean onPreDrawListener$lambda$0(VisibilityTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isTracking) {
            this$0.scheduleVisibilityCheck();
        }
        return true;
    }

    public static final /* synthetic */ void access$setVisibilityScheduled$p(VisibilityTracker $this, boolean bl) {
        $this.isVisibilityScheduled = bl;
    }

    public static final /* synthetic */ View access$getView$p(VisibilityTracker $this) {
        return $this.view;
    }

    public static final /* synthetic */ Function2 access$getOnVisibilityChanged$p(VisibilityTracker $this) {
        return $this.onVisibilityChanged;
    }
}

