package com.particles.msp.adapter

import com.particles.msp.api.AdRequest
import com.particles.msp.util.Logger
import kotlinx.coroutines.suspendCancellableCoroutine
import kotlin.coroutines.resume

interface BidTokenProvider {
    fun fetch(adRequest: AdRequest, onComplete: (String) -> Unit)
}

suspend fun BidTokenProvider.fetchAsync(adRequest: AdRequest): String =
    suspendCancellableCoroutine { cont ->
        Logger.verbose("${this.javaClass.simpleName} start to fetch bid token")
        fetch(adRequest) { token ->
            Logger.verbose("${this.javaClass.simpleName} bid token received: $token")
            cont.resume(token)
        }
    }
