package com.particles.msp.api

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide


class NativeAdView: FrameLayout {
    private var view: View? = null
    private var titleTextView: TextView? = null
    private var bodyTextView: TextView? = null
    private var advertiserTextView: TextView? = null
    private var callToActionTextView: TextView? = null
    private var mediaView: ViewGroup? = null
    private var iconView: ViewGroup? = null
    private var optionsView: ViewGroup? = null

    val adTitleView: TextView?
        get() = titleTextView
    val adBodyView: TextView?
        get() = bodyTextView
    val AdvertiserView: TextView?
        get() = advertiserTextView
    val AdCallToActionView: TextView?
        get() = callToActionTextView
    val AdMediaView: ViewGroup?
        get() = mediaView
    val AdOptionsView: ViewGroup?
        get() = optionsView
    val AdIconView: ViewGroup?
        get() = iconView

    // Primary constructor used when creating the view in code
    constructor(context: Context) : super(context) {}

    // Constructor used when inflating the view from XML
    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {}

    // Constructor needed for correct inflation from XML with a style
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {}

    constructor(nativeAd: NativeAd, nativeAdViewBinder: NativeAdViewBinder, context: Context) : super(context) {
        this.view = LayoutInflater.from(context).inflate(nativeAdViewBinder.layoutResourceId, this, false)
        this.addView(view)
        this.titleTextView = this.findViewById(nativeAdViewBinder.titleTextViewId)
        this.titleTextView?.text = nativeAd.title

        this.bodyTextView = this.findViewById(nativeAdViewBinder.bodyTextViewId)
        this.bodyTextView?.text = nativeAd.body

        this.advertiserTextView = this.findViewById(nativeAdViewBinder.advertiserTextViewId)
        this.advertiserTextView?.text = nativeAd.advertiser

        this.callToActionTextView = this.findViewById(nativeAdViewBinder.callToActionViewId)
        this.callToActionTextView?.text = nativeAd.callToAction

        this.mediaView = this.findViewById(nativeAdViewBinder.mediaViewId)
        this.mediaView?.let { container ->
            (nativeAd.mediaView as? View)?.let { adView ->
                container.removeAllViews()
                container.addView(adView)
            }
        }

        this.optionsView = this.findViewById(nativeAdViewBinder.optionsViewId)
        this.optionsView?.let { container ->
            (nativeAd.optionsView as? View)?.let { optionsView ->
                container.removeAllViews()
                container.addView(optionsView)
            }
        }

        this.iconView = this.findViewById(nativeAdViewBinder.iconViewId)
        this.iconView?.let { container ->
            if (!nativeAd.iconUrl.isNullOrEmpty()) {
                val imageView = ImageView(context)
                imageView.layoutParams = ViewGroup.LayoutParams(
                    ViewGroup.LayoutParams.WRAP_CONTENT,
                    ViewGroup.LayoutParams.WRAP_CONTENT
                )
                Glide.with(context)
                    .load(nativeAd.iconUrl)
                    .into(imageView)
                container.addView(imageView)
            }
        }

        nativeAd.prepareViewForInteraction(this)
    }
}