package com.particles.msp.api

import androidx.annotation.IdRes
import androidx.annotation.LayoutRes

class NativeAdViewBinder private constructor(
    @LayoutRes val layoutResourceId: Int,
    @IdRes val titleTextViewId: Int,
    @IdRes val advertiserTextViewId: Int,
    @IdRes val bodyTextViewId: Int,
    @IdRes val callToActionViewId: Int,
    @IdRes val mediaViewId: Int,
    @IdRes val iconViewId: Int,
    @IdRes val optionsViewId: Int
    ) {
    class Builder {
        private var layoutResourceId: Int = 0
        private var titleTextViewId: Int = 0
        private var advertiserTextViewId: Int = 0
        private var bodyTextViewId: Int = 0
        private var callToActionViewId: Int = 0
        private var mediaViewId: Int = 0
        private var iconViewId: Int = 0
        private var optionsViewId: Int = 0

        fun layoutResourceId(@LayoutRes layoutResourceId: Int) = apply { this.layoutResourceId = layoutResourceId }
        fun titleTextViewId(@IdRes titleTextViewId: Int) = apply { this.titleTextViewId = titleTextViewId }
        fun advertiserTextViewId(@IdRes advertiserTextViewId: Int) = apply { this.advertiserTextViewId = advertiserTextViewId }
        fun bodyTextViewId(@IdRes bodyTextViewId: Int) = apply { this.bodyTextViewId = bodyTextViewId }
        fun callToActionViewId(@IdRes callToActionViewId: Int) = apply { this.callToActionViewId = callToActionViewId }
        fun mediaViewId(@IdRes mediaViewId: Int) = apply { this.mediaViewId = mediaViewId }
        fun iconViewId(@IdRes iconViewId: Int) = apply { this.iconViewId = iconViewId }
        fun optionsViewId(@IdRes optionsViewId: Int) = apply { this.optionsViewId = optionsViewId }

        fun build() = NativeAdViewBinder(layoutResourceId,
            titleTextViewId,
            advertiserTextViewId,
            bodyTextViewId,
            callToActionViewId,
            mediaViewId,
            iconViewId,
            optionsViewId
        )
    }
}