package com.particles.msp.debug

import com.particles.msp.api.AdListener
import com.particles.msp.api.MSPAd
import com.particles.msp.util.Logger

internal abstract class AdListenerAdapter: AdListener {
    override fun onError(msg: String) {
        Logger.info("[MainActivity] Ads loading error: $msg")
    }

    override fun onAdClicked(ad: MSPAd) {
        Logger.info("[MainActivity]. Ad clicked. info: ${ad.adInfo}")
        ad.sendHideAdEvent("click bait ads")
        ad.sendReportAdEvent("click bait ads", "test description: click bait ads")
    }

    override fun onAdImpression(ad: MSPAd) {
        Logger.info("[MainActivity]. Ad is displayed. info: ${ad.adInfo}")
    }

    override fun onAdDismissed(ad: MSPAd) {
        Logger.info("[MainActivity]. Ad is dismissed. info: ${ad.adInfo}")
    }

}