package com.particles.msp.debug

/**
 * Inter-Activity Parameters Key
 */
internal const val KEY_NETWORK = "key_network"
internal const val KEY_FORMAT = "key_format"
internal const val KEY_CREATIVE_TYPE = "key_creative_type"
internal const val KEY_LAYOUT = "key_layout"
internal const val KEY_HIGH_ENGAGEMENT = "key_high_engagement"
internal const val KEY_PLACEMENT_ID = "key_placement_id"
/**
 * Ad Network
 */
internal const val GOOGLE = "Google"
internal const val FACEBOOK = "Facebook"
internal const val NOVA = "Nova"
internal const val PUBMATIC = "Pubmatic"

internal val networkSet = setOf(GOOGLE, FACEBOOK, NOVA, PUBMATIC)

/**
 * Ad Format
 */
internal const val BANNER = "Banner"
internal const val NATIVE = "Native"
internal const val MULTI_FORMAT = "Multi_Format(Banner & Native)"
internal const val INTERSTITIAL = "Interstitial"

/**
 * Ad Creative Type
 */
internal const val IMAGE = "Image"
internal const val VIDEO = "Video"

/**
 * Ad Layout
 */
internal const val HORIZONTAL = "Horizontal"
internal const val VERTICAL = "Vertical"

/**
 * Ad High Engagement
 */
internal const val YES = "yes"
internal const val NO = "no"

internal const val TAG = "[debugger]"