package com.particles.msp.debug.state

internal sealed interface AdDebugInfoUiState {
    data object Loading: AdDebugInfoUiState

    data class AdDebugInfo(
        val placementIds: List<String> = emptyList(),
        val networks: List<AdDebugItemUiState> = emptyList(),
        val formats: List<AdDebugItemUiState> = emptyList(),
        val creativeTypes: List<AdDebugItemUiState> = emptyList(),
        val layouts: List<AdDebugItemUiState> = emptyList(),
        val highEngagements: List<AdDebugItemUiState> = emptyList(),
    ): AdDebugInfoUiState

    data class Error(
        val code: String,
        val msg: String
    ): AdDebugInfoUiState
}