package com.particles.msp.debug.viewmodel

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewmodel.CreationExtras
import com.particles.msp.debug.repository.AdDebugDataRepository

internal class AdDebugViewModelFactory(
    private val repository: AdDebugDataRepository
): ViewModelProvider.Factory {

    @Suppress("UNCHECKED_CAST")
    override fun <T : ViewModel> create(modelClass: Class<T>, extras: CreationExtras): T {
        if (modelClass.isAssignableFrom(AdDebugViewModel::class.java)) {
            return AdDebugViewModel(repository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }

}