package com.particles.msp.debug.ui

import ai.themsp.mspcore.R
import android.content.Context
import android.graphics.drawable.InsetDrawable
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.LinearLayout
import android.widget.TextView
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.core.content.withStyledAttributes
import androidx.recyclerview.widget.DividerItemDecoration
import androidx.core.graphics.drawable.toDrawable
import com.particles.msp.debug.state.AdDebugItemUiState

internal class TitledListView @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleRes: Int = 0,
): LinearLayout(context, attributeSet, defStyleRes) {

    private val recyclerView: RecyclerView

    private val tvTitle: TextView

    private lateinit var insetDivider: InsetDrawable

    private val adapter: TitledListAdapter

    init {
        LayoutInflater.from(context).inflate(R.layout.titled_list_view, this, true)

        tvTitle = findViewById(R.id.titled_list_view_title)

        recyclerView = findViewById(R.id.titled_list_view_recycler)
        recyclerView.layoutManager = object: LinearLayoutManager(context) {
            override fun canScrollVertically(): Boolean {
                return false
            }
        }
        adapter = TitledListAdapter(listOf())
        recyclerView.adapter = adapter

        handleCustomAttrs(attributeSet)

        val itemDecoration = DividerItemDecoration(context, DividerItemDecoration.VERTICAL)
        itemDecoration.setDrawable(insetDivider)
        recyclerView.addItemDecoration(itemDecoration)
    }

    private fun handleCustomAttrs(attributeSet: AttributeSet?) {
        context.withStyledAttributes(attributeSet, R.styleable.TitledListView) {
            val title = getString(R.styleable.TitledListView_title)
            tvTitle.text = title

            val divider = resources.getColor(R.color.divider_color).toDrawable()
            val inset = resources.getDimensionPixelOffset(R.dimen.divider_inset)
            insetDivider = InsetDrawable(divider, inset, 0, 0, 0)
        }
    }

    fun setList(list: List<AdDebugItemUiState>) {
        adapter.updateList(list)
    }

}