/*
 * Decompiled with CFR 0.152.
 */
package com.particles.msp.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RequiresPermission;
import androidx.core.app.ActivityCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.particles.mes.android.MesTracker;
import com.particles.msp.util.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u001a\u0006\u0010\u0010\u001a\u00020\b\u001a\u0010\u0010\u0011\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0006\u0010\u0012\u001a\u00020\b\u001a\u0012\u0010\u0013\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0007\u001a\u0010\u0010\u0014\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0010\u0010\u0016\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\b\u001a\u0010\u0010\u001a\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d\u001a$\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0!\u001a\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\b\u00a8\u0006$"}, d2={"getAppInstallTime", "", "context", "Landroid/content/Context;", "getAvailableMemory", "getBatteryLevel", "", "getBatteryStatus", "", "getBidder", "bidJsonStr", "getBuckets", "", "ext", "", "", "getDeviceTimezone", "getFontSize", "getIsInForeground", "getIsLowDataMode", "getIsLowPowerMode", "getLastSystemBootTime", "getLastSystemUpdateTime", "getMesTracker", "Lcom/particles/mes/android/MesTracker;", "mesHostUrl", "getOrientation", "loadJSONFromRaw", "resourceId", "", "setBatteryStatusAndLevel", "", "customParams", "", "trackUrl", "url", "msp-core_mavenRelease"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/particles/msp/util/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String loadJSONFromRaw(@NotNull Context context, int resourceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = context.getResources().openRawResource(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openRawResource(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }

    @NotNull
    public static final String getBidder(@NotNull String bidJsonStr) {
        Intrinsics.checkNotNullParameter((Object)bidJsonStr, (String)"bidJsonStr");
        String bidder = "";
        try {
            String string2 = new JSONObject(bidJsonStr).getJSONObject("ext").getJSONObject("prebid").getJSONObject("meta").getString("adaptercode");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            bidder = string2;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return bidder;
    }

    @NotNull
    public static final List<String> getBuckets(@Nullable Map<String, ? extends Object> ext) {
        List buckets;
        block3: {
            buckets = new ArrayList();
            try {
                Map<String, ? extends Object> map = ext;
                Object object = map != null ? map.get("msp_exp_bucket_info") : null;
                JSONObject jSONObject = object instanceof JSONObject ? (JSONObject)object : null;
                JSONObject jSONObject2 = jSONObject;
                if (jSONObject2 == null || (jSONObject2 = jSONObject2.optJSONArray("exp_bucket_list")) == null) break block3;
                JSONObject it = jSONObject2;
                boolean bl = false;
                int n = it.length();
                for (int i = 0; i < n; ++i) {
                    String string2;
                    String string3 = string2 = it.optString(i);
                    if (string3 == null) continue;
                    Intrinsics.checkNotNull((Object)string3);
                    String bucket = string2;
                    boolean bl2 = false;
                    if (!(((CharSequence)bucket).length() > 0)) continue;
                    buckets.add(bucket);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return buckets;
    }

    public static final void trackUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(url, null){
            int label;
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            URLConnection uRLConnection = new URL(this.$url).openConnection();
                            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                            connection.connect();
                            connection.getInputStream().close();
                            connection.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public static final MesTracker getMesTracker(@NotNull String mesHostUrl) {
        MesTracker mesTracker;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)mesHostUrl, (String)"mesHostUrl");
        String it = string3 = mesHostUrl;
        boolean bl = false;
        String string4 = string2 = ((CharSequence)it).length() > 0 ? string3 : null;
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            mesTracker = MesTracker.Companion.obtain(it);
        } else {
            mesTracker = null;
        }
        return mesTracker;
    }

    public static final long getAppInstallTime(@Nullable Context context) {
        long l;
        Context context2 = context;
        if (context2 == null) {
            return 0L;
        }
        Context nonNullContext = context2;
        try {
            l = nonNullContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            l = 0L;
        }
        return l;
    }

    public static final long getAvailableMemory(@Nullable Context context) {
        ActivityManager.MemoryInfo memInfo;
        block1: {
            ActivityManager activityManager;
            Context context2 = context;
            Object object = context2 != null ? context2.getSystemService("activity") : null;
            ActivityManager activityManager2 = activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
            if (activityManager == null) {
                Logger.INSTANCE.info("getAvailableMemory: context is null or get ActivityManager failed.");
            }
            memInfo = new ActivityManager.MemoryInfo();
            ActivityManager activityManager3 = activityManager;
            if (activityManager3 == null) break block1;
            activityManager3.getMemoryInfo(memInfo);
        }
        return memInfo.availMem;
    }

    @NotNull
    public static final String getDeviceTimezone() {
        TimeZone timeZone = TimeZone.getDefault();
        int offsetInMillis = timeZone.getOffset(System.currentTimeMillis());
        int hours = offsetInMillis / 3600000;
        int minutes = offsetInMillis % 3600000 / 60000;
        Locale locale = Locale.US;
        String string2 = "%+03d:%02d";
        Object[] objectArray = new Object[]{hours, Math.abs(minutes)};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        return string3;
    }

    @NotNull
    public static final String getFontSize(@Nullable Context context) {
        String string2;
        Context context2 = context;
        if (context2 != null) {
            Context it = context2;
            boolean bl = false;
            float fontScale = it.getResources().getConfiguration().fontScale;
            string2 = fontScale == 1.0f ? "m" : (fontScale < 1.0f ? "s" : (fontScale > 1.0f ? "l" : "unknown"));
        } else {
            string2 = "unknown";
        }
        return string2;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @NotNull
    public static final String getIsLowDataMode(@Nullable Context context) {
        if (context == null) {
            Logger.INSTANCE.info("getIsLowDataMode: context is null");
            return "unknown";
        }
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            ConnectivityManager connectivityManager;
            Object object = context.getSystemService("connectivity");
            ConnectivityManager connectivityManager2 = connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
            if (connectivityManager == null) {
                Logger.INSTANCE.info("getIsLowDataMode: get ConnectivityManager failed");
                return "unknown";
            }
            return connectivityManager.isActiveNetworkMetered() ? "true" : "false";
        }
        Logger.INSTANCE.info("getIsLowDataMode: no permission of ACCESS_NETWORK_STATE");
        return "unknown";
    }

    @NotNull
    public static final String getIsLowPowerMode(@Nullable Context context) {
        PowerManager powerManager;
        if (context == null) {
            Logger.INSTANCE.info("getIsLowPowerMode: context is null");
            return "unknown";
        }
        Object object = context.getSystemService("power");
        PowerManager powerManager2 = powerManager = object instanceof PowerManager ? (PowerManager)object : null;
        if (powerManager == null) {
            Logger.INSTANCE.info("getIsLowPowerMode: get PowerManager failed");
            return "unknown";
        }
        return powerManager.isPowerSaveMode() ? "true" : "false";
    }

    public static final void setBatteryStatusAndLevel(@Nullable Context context, @NotNull Map<String, Object> customParams) {
        Intrinsics.checkNotNullParameter(customParams, (String)"customParams");
        if (context == null) {
            Logger.INSTANCE.info("getBatteryStatus: context is null");
            customParams.put("battery_level", "unknown");
            customParams.put("battery_status", "unknown");
        } else {
            BatteryManager batteryManager;
            Object object = context.getSystemService("batterymanager");
            BatteryManager batteryManager2 = batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
            if (batteryManager == null) {
                Logger.INSTANCE.info("getBatteryStatus: get BatteryManager failed");
                customParams.put("battery_level", "unknown");
                customParams.put("battery_status", "unknown");
            } else {
                int batteryCapacity = batteryManager.getIntProperty(4);
                Map<String, Object> map = customParams;
                Object object2 = "battery_level";
                String string2 = "%.2f";
                Object object3 = new Object[]{Float.valueOf((float)batteryCapacity / 100.0f)};
                String string3 = String.format(string2, Arrays.copyOf(object3, ((Object[])object3).length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                string2 = string3;
                map.put((String)object2, string2);
                if (Build.VERSION.SDK_INT >= 26) {
                    String string4;
                    int batteryStatus = batteryManager.getIntProperty(6);
                    object2 = customParams;
                    string2 = "battery_status";
                    switch (batteryStatus) {
                        case 2: {
                            string4 = "charging";
                            break;
                        }
                        case 3: {
                            string4 = "unplugged";
                            break;
                        }
                        case 5: {
                            string4 = "full";
                            break;
                        }
                        case 4: {
                            string4 = "unknown";
                            break;
                        }
                        case 1: {
                            string4 = "unknown";
                            break;
                        }
                        default: {
                            string4 = "unknown";
                        }
                    }
                    object3 = string4;
                    object2.put(string2, object3);
                } else {
                    customParams.put("battery_status", "unknown");
                }
            }
        }
    }

    @NotNull
    public static final String getBatteryStatus(@Nullable Context context) {
        String string2;
        if (context == null) {
            string2 = "unknown";
        } else {
            BatteryManager batteryManager;
            Object object = context.getSystemService("batterymanager");
            BatteryManager batteryManager2 = batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
            if (batteryManager == null) {
                string2 = "unknown";
            } else if (Build.VERSION.SDK_INT >= 26) {
                int batteryStatus = batteryManager.getIntProperty(6);
                switch (batteryStatus) {
                    case 2: {
                        string2 = "charging";
                        break;
                    }
                    case 3: {
                        string2 = "unplugged";
                        break;
                    }
                    case 5: {
                        string2 = "full";
                        break;
                    }
                    case 4: {
                        string2 = "unknown";
                        break;
                    }
                    case 1: {
                        string2 = "unknown";
                        break;
                    }
                    default: {
                        string2 = "unknown";
                        break;
                    }
                }
            } else {
                string2 = "unknown";
            }
        }
        return string2;
    }

    public static final float getBatteryLevel(@Nullable Context context) {
        BatteryManager batteryManager;
        Object object = context != null ? context.getSystemService("batterymanager") : null;
        BatteryManager batteryManager2 = batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
        return batteryManager != null ? (float)batteryManager.getIntProperty(4) / 100.0f : 0.0f;
    }

    @NotNull
    public static final String getOrientation(@Nullable Context context) {
        String string2;
        Display display;
        Object object;
        if (context == null) {
            Logger.INSTANCE.info("getOrientation: context is null");
            return "unknown";
        }
        if (Build.VERSION.SDK_INT >= 30) {
            DisplayManager displayManager;
            object = context.getSystemService("display");
            DisplayManager displayManager2 = displayManager = object instanceof DisplayManager ? (DisplayManager)object : null;
            if (displayManager == null) {
                Logger.INSTANCE.info("getOrientation: get DisplayManager failed");
                return "unknown";
            }
            display = displayManager.getDisplay(0);
        } else {
            WindowManager windowManager;
            object = context.getSystemService("window");
            WindowManager windowManager2 = windowManager = object instanceof WindowManager ? (WindowManager)object : null;
            if (windowManager == null) {
                Logger.INSTANCE.info("getOrientation: get WindowManager failed");
                return "unknown";
            }
            display = windowManager.getDefaultDisplay();
        }
        Display display2 = display;
        int rotation = display2.getRotation();
        int orientation = context.getResources().getConfiguration().orientation;
        switch (rotation) {
            case 0: {
                if (orientation == 1) {
                    string2 = "portrait";
                    break;
                }
                string2 = "landscapeLeft";
                break;
            }
            case 1: {
                if (orientation == 2) {
                    string2 = "landscapeLeft";
                    break;
                }
                string2 = "portraitUpsideDown";
                break;
            }
            case 2: {
                if (orientation == 1) {
                    string2 = "portraitUpsideDown";
                    break;
                }
                string2 = "landscapeRight";
                break;
            }
            case 3: {
                if (orientation == 2) {
                    string2 = "landscapeRight";
                    break;
                }
                string2 = "portrait";
                break;
            }
            default: {
                string2 = "unknown";
            }
        }
        return string2;
    }

    @NotNull
    public static final String getIsInForeground() {
        boolean isForeground = ProcessLifecycleOwner.get().getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        Logger.INSTANCE.info("getIsInForeground: " + isForeground);
        return isForeground ? "true" : "false";
    }

    public static final long getLastSystemBootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    public static final long getLastSystemUpdateTime(@Nullable Context context) {
        long l;
        if (context == null) {
            Logger.INSTANCE.info("getLastSystemUpdateTime: context is null");
            return 0L;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageInfo("android", 0);
            l = info.lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.INSTANCE.info("getLastSystemUpdateTime failed: " + e.getMessage());
            l = 0L;
        }
        return l;
    }
}

