package com.particles.msp.debug

import android.text.TextUtils
import android.view.View

internal fun visibleOrGone(visible: Boolean): Int = if (visible) View.VISIBLE else View.GONE

internal fun convertToValue(text: String): String {
    val lowerText = text.lowercase()
    return when {
        TextUtils.equals(text, FACEBOOK) -> "msp_fb"
        networkSet.contains(text) -> "msp_$lowerText"
        TextUtils.equals(text, MULTI_FORMAT) -> "multi_format"
        else -> lowerText
    }
}

internal fun getTestParams(
    network: String,
    creativeType: String,
    layout: String,
    highEngagement: String): Map<String, Any> {
    val testParams: MutableMap<String, Any> = HashMap()
    testParams["test_ad"] = true
    testParams["ad_network"] = network
    testParams["creative_type"] = creativeType
    testParams["is_vertical"] = layout == "vertical"
    if (highEngagement == "yes") {
        testParams["layout"] = "cancel_top_right"
    }
    return testParams
}