package com.particles.msp.util

import android.content.Context
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

object AdIdRepo {
    private const val ZERO = "00000000-0000-0000-0000-000000000000"
    @Volatile private var cache: String? = null

    suspend fun get(context: Context): String {
        cache?.let { return it }
        val appCtx = context.applicationContext
        return withContext(Dispatchers.IO) {
            runCatching {
                val id = com.google.android.gms.ads.identifier.AdvertisingIdClient
                    .getAdvertisingIdInfo(appCtx)
                    ?.id
                    ?.takeUnless { it.isNullOrBlank() }
                    ?: ZERO
                if (id != ZERO) {
                    cache = id
                }
                id
            }.getOrDefault(ZERO)
        }
    }
}