package com.particles.msp.util

import android.content.Context
import com.google.android.gms.appset.AppSet
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.tasks.await
import kotlinx.coroutines.withContext

object AppSetIdRepo {
    private const val ZERO = "00000000-0000-0000-0000-000000000000"
    @Volatile private var cache: String? = null

    /**
     * Returns the App Set ID (UUID-like) or ZERO if unavailable.
     * Caches in-memory after first successful fetch, just like AdIdRepo.
     */
    suspend fun get(context: Context): String {
        cache?.let { return it }
        val appCtx = context.applicationContext

        return withContext(Dispatchers.IO) {
            runCatching {
                val info = AppSet.getClient(appCtx).appSetIdInfo.await()
                val id = info.id.takeUnless { it.isBlank() } ?: ZERO
                if (id != ZERO) cache = id
                id
            }.getOrDefault(ZERO)
        }
    }
}