package com.particles.novaadapter

import com.particles.android.ads.nativead.MediaListener
import com.particles.msp.api.MediaController as MspMediaController
import com.particles.msp.api.MediaListener as MspMediaListener

class NovaMediaController : MspMediaController, MediaListener {

    private val listeners = mutableListOf<MspMediaListener>()

    override fun addMediaListener(listener: MspMediaListener) {
        listeners.add(listener)
    }

    override fun removeMediaListener(listener: MspMediaListener) {
        listeners.remove(listener)
    }

    override fun onDurationUpdate(duration: Long) {
        listeners.forEach { it.onDurationUpdate(duration) }
    }

    override fun onProgressUpdate(position: Long, bufferedPosition: Long) {
        listeners.forEach { it.onProgressUpdate(position, bufferedPosition) }
    }

}
