package com.particles.android.ads

import android.location.Address
import android.location.Location
import com.particles.android.ads.internal.util.DeviceInfo

class AdRequest private constructor(
    val id: String,
    val adString: String?,
    val userId: String?,
    val profileId: String?,
    val sessionId: String?,
    val deviceId: String?,
    val adSize: AdSize?,
    val address: Address?,
    val location: Location?,
    val weather: String?,
    val testMode: Boolean,
    val usPrivacy: String?,
    val extras: Map<String, Any?>,
    val requestOptions: RequestOptions,
) {
    class Builder(val id: String? = null) {
        private var adString: String? = null
        private var userId: String? = null
        private var profileId: String? = null
        private var sessionId: String? = null
        private var deviceId: String? = null
        private var adSize: AdSize? = null
        private var address: Address? = null
        private var location: Location? = null
        private var weather: String? = null
        private var testMode: Boolean = false
        private var usPrivacy: String? = null
        private val extras: MutableMap<String, Any?> = mutableMapOf()
        private var requestOptions: RequestOptions? = null

        fun setAdString(adString: String?) = apply {
            this.adString = adString
        }

        fun setUserId(id: String?) = apply {
            userId = id
        }

        fun setProfileId(id: String?) = apply {
            profileId = id
        }

        fun setSessionId(id: String?) = apply {
            sessionId = id
        }

        fun setDeviceId(id: String?) = apply {
            deviceId = id
        }

        fun setAdSize(adSize: AdSize?) = apply {
            this.adSize = adSize
        }

        fun setAddress(address: Address?) = apply {
            this.address = address
        }

        fun setLocation(location: Location?) = apply {
            this.location = location
        }

        fun setWeather(weather: String?) = apply {
            this.weather = weather
        }

        fun setTestMode(testMode: Boolean) = apply {
            this.testMode = testMode
        }

        fun setUsPrivacy(usPrivacy: String) = apply {
            this.usPrivacy = usPrivacy
        }

        fun setExtras(extras: Map<String, Any?>?) = apply {
            this.extras.clear()
            extras?.let { this.extras.putAll(it) }
        }

        fun addExtras(extras: Map<String, Any?>?) = apply {
            extras?.let { this.extras.putAll(it) }
        }

        fun addExtra(key: String, value: Any?) = apply {
            extras[key] = value
        }

        fun requestOptions(requestOptions: RequestOptions?) = apply {
            this.requestOptions = requestOptions
        }

        fun build(): AdRequest {
            return AdRequest(
                id = id ?: DeviceInfo.generateUUID(),
                adString = adString,
                userId = userId,
                profileId = profileId,
                sessionId = sessionId,
                deviceId = deviceId,
                adSize = adSize,
                address = address,
                location = location,
                weather = weather,
                testMode = testMode,
                usPrivacy = usPrivacy,
                extras = extras,
                requestOptions = requestOptions ?: RequestOptions.DEFAULT
            )
        }
    }
}
