package com.particles.android.ads

import android.content.Context
import android.util.TypedValue

data class AdSize(val width: Int, val height: Int) {

    fun getWidthInPixels(context: Context): Int {
        return when {
            width >= 0 -> {
                TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,
                    width.toFloat(), context.resources.displayMetrics).toInt()
            }
            else -> width
        }
    }

    fun getHeightInPixels(context: Context): Int {
        return when {
            height >= 0 -> {
                TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,
                    height.toFloat(), context.resources.displayMetrics).toInt()
            }
            else -> width
        }
    }

    companion object {
        @JvmStatic val INVALID = AdSize(0, 0)
        @JvmStatic val BANNER = AdSize(320, 50)
        @JvmStatic val MEDIUM_RECTANGLE = AdSize(300, 250)
    }
}
