package com.particles.android.ads.internal

import com.particles.android.ads.AdError

enum class AdErrorPool(val code: Int, val message: String) {
    GENERAL_LOAD_ERROR(1000, ""),
    NO_AD_UNIT_ID(1001, ""),

    GENERAL_FILL_ERROR(2000, ""),
    NO_AD_FILLED(2001, ""),

    GENERAL_SHOW_ERROR(4000, ""),

    GENERAL_CLICK_THROUGH_ERROR(5000, ""),

    GENERAL_DESTINATION_ERROR(6000, ""),

    MAX_ERROR_PLACEHOLDER(9999, "");

    fun toAdError(): AdError {
        return AdError(code, message)
    }

    fun toAdError(cause: Throwable): AdError {
        return AdError(code, message, cause)
    }
}
