package com.particles.android.ads.internal

import android.content.Context
import android.os.Build
import com.particles.android.ads.NovaSdk
import com.particles.android.ads.internal.util.DeviceInfo

internal object NovaInternal {
    val context: Context get() {
        return NovaSdk.getContext()
    }

    val apiServer: String get() {
        return "https://dsp.newsbreak.com/api"
    }

    val osName = "android"
    val osVersion = Build.VERSION.RELEASE
    val appVersion by lazy { DeviceInfo.getAppVersionName(context) }

}