package com.particles.android.ads.internal.data.mapper

import com.particles.android.ads.internal.data.entity.AdEntity
import com.particles.android.ads.internal.data.entity.AddonItemEntity
import com.particles.android.ads.internal.data.entity.CarouselItemEntity
import com.particles.android.ads.internal.data.entity.CreativeEntity
import com.particles.android.ads.internal.data.entity.VideoItemEntity
import org.json.JSONArray
import org.json.JSONObject

object AdEntityJsonMapper : JsonMapper<AdEntity> {
    override fun map(source: JSONObject): AdEntity {
        return AdEntity(
            raw = source.toString(),
            requestId = source.optString("requestId"),
            adId = source.optString("adId"),
            adSetId = source.optString("adsetId"),
            creative = source.getJSONObject("creative").let { CreativeEntityJsonMapper.map(it) },
            price = source.optDouble("price"),
            startTimeMs = source.optLong("startTimeMs", 0L),
            expirationMs = source.optLong("expirationMs", 0L),
            encryptedAdToken = source.optString("encryptedAdToken"),
        )
    }
}

object CreativeEntityJsonMapper : JsonMapper<CreativeEntity> {
    override fun map(source: JSONObject): CreativeEntity {
        return CreativeEntity(
            adm = source.optString("adm"),
            ctrUrl = source.optString("ctrUrl"),
            headline = source.optString("headline"),
            body = source.optString("body"),
            callToAction = source.optString("callToAction"),
            iconUrl = source.optString("iconUrl"),
            imageUrl = source.optString("imageUrl"),
            isImageClickable = source.optBoolean("isImageClickable", true),
            isVerticalImage = source.optBoolean("isVerticalImage", false),
            address = source.optString("address"),
            advertiser = source.optString("advertiser"),
            creativeType = source.optString("creativeType"),
            thirdPartyImpressionTrackingUrls = parseStringArray(source.optJSONArray("thirdPartyImpressionTrackingUrls")),
            thirdPartyViewTrackingUrls = parseStringArray(source.optJSONArray("thirdPartyViewTrackingUrls")),
            thirdPartyClickTrackingUrls = parseStringArray(source.optJSONArray("thirdPartyClickTrackingUrls")),
            launchOption = source.optString("launchOption"),
            carouselItems = source.optJSONArray("carouselItems")
                ?.let { CarouselEntityJsonMapper.map(it) } ?: emptyList(),
            videoItem = source.optJSONObject("videoItem")?.let { VideoEntityJsonMapper.map(it) },
            addonItem = source.optJSONObject("addonItem")?.let { AddonEntityJsonMapper.map(it) },
        )
    }

    private fun parseStringArray(jsonArray: JSONArray?): List<String> {
        val result = mutableListOf<String>()
        if (jsonArray != null) {
            for (i in 0 until jsonArray.length()) {
                jsonArray.optString(i).let { result.add(it) }
            }
        }
        return result
    }
}

object CarouselEntityJsonMapper : JsonMapper<CarouselItemEntity> {
    override fun map(source: JSONObject): CarouselItemEntity {
        return CarouselItemEntity(
            ctrUrl = source.optString("ctrUrl"),
            body = source.optString("body"),
            callToAction = source.optString("callToAction"),
            imageUrl = source.optString("imageUrl"),
        )
    }
}

object VideoEntityJsonMapper : JsonMapper<VideoItemEntity> {
    override fun map(source: JSONObject): VideoItemEntity {
        return VideoItemEntity(
            videoUrl = source.optString("videoUrl"),
            coverUrl = source.optString("coverUrl"),
            isPlayAutomatically = source.optBoolean("isPlayAutomatically"),
            isLoop = source.optBoolean("isLoop"),
            isMute = source.optBoolean("isMute", true),
            isVideoClickable = source.optBoolean("isVideoClickable"),
            isVertical = source.optBoolean("isVertical"),
            isPlayOnLandingPage = source.optBoolean("isPlayOnLandingPage"),
        )
    }
}

object AddonEntityJsonMapper : JsonMapper<AddonItemEntity> {
    override fun map(source: JSONObject): AddonItemEntity {
        return AddonItemEntity(
            type = source.optString("type"),
            imageUrl = source.optString("imageUrl"),
            displayTime = source.optInt("displayTime"),
        )
    }
}
