package com.particles.android.ads.internal.domain

data class TrackingEvent(
    val time: Long = System.currentTimeMillis(),
    val type: String,
    val action: String? = null,
    val reason: String? = null,
    val offset: Long = 0L,
    val userId: String? = null,
    val profileId: String? = null,
    val sessionId: String? = null,
    val adUnitId: String,
    val encryptedAdToken: String,
    val duration: Long = 0L,
    val videoExtras: VideoExtras? = null,
    val videoProgressExtras: VideoProgressExtras? = null,
    val viewabilityExtras: ViewabilityExtras? = null,
    val clickExtras: ClickExtras? = null,
    val browserExtras: BrowserExtras? = null,
    val extras: Map<String, Any?>? = null,
) {
    companion object {
        const val EVENT_TYPE_IMPRESSION = "AD_EVENT_IMPRESSION"
        const val EVENT_TYPE_CLICK = "AD_EVENT_CLICK"
        const val EVENT_TYPE_VIEWABLE_IMPRESSION = "AD_EVENT_VIEWABLE_IMPRESSION"
        const val EVENT_TYPE_DISMISS_AD = "dismiss_ad"
        const val EVENT_TYPE_HIDE_AD = "hide_ad"
        const val EVENT_TYPE_UNHIDE_AD = "unhide_ad"
        const val EVENT_TYPE_VIDEO_START = "video_start"
        const val EVENT_TYPE_VIDEO_FIRST_QUARTILE = "video_first_quartile"
        const val EVENT_TYPE_VIDEO_MIDPOINT = "video_midpoint"
        const val EVENT_TYPE_VIDEO_THIRD_QUARTILE = "video_third_quartile"
        const val EVENT_TYPE_VIDEO_COMPLETE = "video_complete"
        const val EVENT_TYPE_VIDEO_PAUSE = "video_pause"
        const val EVENT_TYPE_VIDEO_RESUME = "video_resume"
        const val EVENT_TYPE_VIDEO_MUTE = "video_mute"
        const val EVENT_TYPE_VIDEO_UNMUTE = "video_unmute"
        const val EVENT_TYPE_VIDEO_PROGRESS = "video_progress"

        const val EVENT_TYPE_BROWSER_START = "nova_landing_page_start"
        const val EVENT_TYPE_BROWSER_TEXT_LOADED = "nova_landing_page_text_load"
        const val EVENT_TYPE_BROWSER_LOADED = "nova_landing_page_all_load"
        const val EVENT_TYPE_BROWSER_CLOSE = "nova_landing_page_close"
        const val EVENT_TYPE_BROWSER_RESUME = "nova_landing_page_jump_in"
        const val EVENT_TYPE_BROWSER_PAUSE = "nova_landing_page_jump_out"
    }
}

data class VideoExtras(
    val latency: Int,
    val duration: Int,
    val isAutoPlay: Boolean,
    val isLoopPlay: Boolean,
    val isMutePlay: Boolean,
    val isVideoClickable: Boolean,
)

data class VideoProgressExtras(
    val duration: Int,
    val position: Int,
    val repeatCount: Int,
)

data class ViewabilityExtras(
    val viewportSize: String,
    val timeOnScreenInMillis: String,
    val creativePosition: String,
)

data class ClickExtras(
    val clickAreaName: String,
)

data class BrowserExtras(
    val seq: Int = 0,
    val status: Int = 0,
    val pageIndex: Int,
    val scrollDepth: Float,
)
