package com.particles.android.ads.internal.loader

import android.content.Context
import com.particles.android.ads.*
import com.particles.android.ads.internal.AdErrorPool
import com.particles.android.ads.internal.InterstitialAdImpl
import com.particles.android.ads.internal.domain.Ad
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.util.Callback
import com.particles.android.ads.interstitial.InterstitialAd

class InterstitialAdLoader(
    private val context: Context,
    private val adUnitId: String,
    private val listener: AdLoadListener<InterstitialAd>
) : AdLoader {

    override fun loadAds(adRequest: AdRequest, maxNumberOfAds: Int) {
        val callback = object : Callback<List<Ad>> {
            override fun onSuccess(result: List<Ad>) {
                val ads = result.map {
                    InterstitialAdImpl(
                        AdSession(
                            adUnitId = adUnitId,
                            adRequest = adRequest,
                            ad = it
                        )
                    )
                }
                listener.onAdLoaded(ads)
            }

            override fun onFailure(e: Throwable) {
                val adError = if (e is AdError) e else AdErrorPool.GENERAL_LOAD_ERROR.toAdError(e)
                listener.onAdLoadFailed(adError)
            }
        }
        val task = GetAdsTask2(
            context,
            AdFormat.INTERSTITIAL.name.lowercase(),
            adUnitId,
            adRequest,
            maxNumberOfAds,
        )
        task.getAds(callback)
    }
}
