package com.particles.android.ads.internal.rendering

import android.app.Activity
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import android.widget.ImageView
import com.bumptech.glide.Glide
import com.particles.android.ads.R
import com.particles.android.ads.banner.BannerAdView
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.util.viewability.OMTracker

class BannerImageAdView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : BannerAdView(context, attrs, defStyleAttr) {

    private val imageView = ImageView(context)
    private val omTracker by lazy {
        val adVerifications = adSession?.ad?.creative?.adVerifications
        if (adVerifications != null && adVerifications.isNotEmpty()) {
            OMTracker.createNativeDisplayTracker(this, adVerifications)
        } else null
    }

    init {
        imageView.scaleType = ImageView.ScaleType.CENTER_CROP
        imageView.setOnClickListener { ad?.onAdClicked(this) }
        addView(imageView, MATCH_PARENT, MATCH_PARENT)
        LayoutInflater.from(context).inflate(R.layout._nova_banner_ad_marking, this)
    }

    override fun onRenderAd(adSession: AdSession?) {
        val uri = adSession?.ad?.creative?.images?.firstOrNull()?.url
        if (isValidContextForGlide(context)) {
            Glide.with(context).load(uri).into(imageView)
        }
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        omTracker?.startTracking()
        omTracker?.trackImpression()
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        if (parent == null) {
            omTracker?.stopTracking()
        }
    }

    private fun isValidContextForGlide(context: Context?): Boolean {
        if (context == null) {
            return false
        }

        if (context is Activity) {
            if (context.isDestroyed || context.isFinishing) {
                return false
            }
        }

        return true
    }
}
