package com.particles.android.ads.internal.rendering.addon

import android.widget.FrameLayout
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.domain.DisplayCardAddon

class AddonViewHelper(private val container: FrameLayout) {

    fun setAddon(ad: AdSession, onClose: () -> Unit) {
        val addon = ad.ad.creative.addon
        if (addon is DisplayCardAddon) {
            DisplayCardAddonViewHolder(container, onClose).setAddon(addon)
        }
    }
}
