package com.particles.android.ads.internal.rendering.addon

import android.app.Activity
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import com.bumptech.glide.Glide
import com.particles.android.ads.R
import com.particles.android.ads.internal.domain.DisplayCardAddon

class DisplayCardAddonViewHolder(
    container: ViewGroup,
    private var onClose: (() -> Unit)? = null,
) {

    private val context = container.context
    private val imageView: ImageView?
    private val closeView: View?

    init {
        val view = LayoutInflater.from(context).inflate(R.layout._nova_addon_display_card, container)
        imageView = view.findViewById(R.id.addon_image)
        closeView = view.findViewById(R.id.addon_close)
        closeView?.setOnClickListener { onClose?.invoke() }
    }

    fun setAddon(addon: DisplayCardAddon) {
        setImageUri(addon.imageUrl)
    }

    private fun setImageUri(uri: String?) {
        if (imageView != null && isValidContextForGlide(context)) {
            Glide.with(context).load(uri).into(imageView)
        }
    }

    private fun isValidContextForGlide(context: Context?): Boolean {
        if (context == null) {
            return false
        }

        if (context is Activity) {
            if (context.isDestroyed || context.isFinishing) {
                return false
            }
        }

        return true
    }
}
