package com.particles.android.ads.internal.util.viewability

data class ViewabilityState(
    val viewportWidth: Int,
    val viewportHeight: Int,

    val viewTop: Int,
    val viewLeft: Int,
    val viewRight: Int,
    val viewBottom: Int,

    val visibleTop: Int,
    val visibleLeft: Int,
    val visibleRight: Int,
    val visibleBottom: Int,

    val visibleTime100: Long,
    val visibleTime75: Long,
    val visibleTime50: Long,
    val visibleTime25: Long,
    val visibleTime1: Long,
) {
    val visible: Boolean
        get() = (visibleRight > visibleLeft) && (visibleBottom > visibleTop)

    val viewable: Boolean
        get() = visibleTime100 >= 1000L || visibleTime75 >= 1000L || visibleTime50 >= 1000L
}
