package com.particles.android.ads.banner

import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import com.particles.android.ads.AdSize
import com.particles.android.ads.internal.BannerAdImpl
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.util.AdViewHelper

abstract class BannerAdView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    var ad: BannerAdImpl? = null
    var adSize: AdSize? = null
    var adSession: AdSession? = null
        set(value) {
            if (field != value) {
                field = value
                onRenderAd(value)
            }
        }

    private val adViewHelper by lazy { AdViewHelper(this) }

    protected abstract fun onRenderAd(adSession: AdSession?)

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        adViewHelper.register(ad)
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        var newWidthMeasureSpec = widthMeasureSpec
        var newHeightMeasureSpec = heightMeasureSpec

        val width = adSize?.getWidthInPixels(context) ?: 0
        if (width > 0) {
            newWidthMeasureSpec = MeasureSpec.makeMeasureSpec(
                resolveSize(width, widthMeasureSpec),
                MeasureSpec.EXACTLY
            )
        }

        var height = adSize?.getHeightInPixels(context) ?: 0
        if (height > 0) {
            if (width > 0) {
                height = height * MeasureSpec.getSize(newWidthMeasureSpec) / width
            }
            newHeightMeasureSpec = MeasureSpec.makeMeasureSpec(
                resolveSize(height, heightMeasureSpec),
                MeasureSpec.EXACTLY
            )
        }

        super.onMeasure(newWidthMeasureSpec, newHeightMeasureSpec)
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        adViewHelper.unregister()
    }

}
