package com.particles.android.ads.internal

import android.content.Context
import android.view.View
import com.particles.android.ads.banner.BannerAd
import com.particles.android.ads.banner.BannerAdListener
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.banner.BannerAdView
import com.particles.android.ads.internal.rendering.BannerHtmlAdView
import com.particles.android.ads.internal.rendering.BannerImageAdView

class BannerAdImpl(context: Context, adSession: AdSession) : BannerAd, BaseAdImpl(adSession)  {

    private val adView: BannerAdView

    init {
        adView = createAdView(context, adSession)
        adView.ad = this
        adView.adSession = adSession
        adView.adSize = adSession.adSize
    }

    override fun getAdView(): View {
        return adView
    }

    override fun setAdListener(listener: BannerAdListener) {
        this.adListener = listener
    }

    private fun createAdView(context: Context, adSession: AdSession): BannerAdView {
        return if (adSession.ad.creative.adm.isNotEmpty()) {
            BannerHtmlAdView(context)
        } else {
            BannerImageAdView(context)
        }
    }
}
