package com.particles.android.ads.internal

import android.app.Activity
import android.content.Intent
import com.particles.android.ads.AdActivity
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.util.AdBank
import com.particles.android.ads.interstitial.InterstitialAd
import com.particles.android.ads.interstitial.InterstitialAdListener

class InterstitialAdImpl(adSession: AdSession) : InterstitialAd, BaseAdImpl(adSession) {

    override fun setAdListener(listener: InterstitialAdListener) {
        this.adListener = listener
    }

    override fun show(activity: Activity) {
        val intent = Intent(activity, AdActivity::class.java)
        intent.putExtra(AdActivity.EXTRA_AD_KEY, AdBank.put(this))
        activity.startActivity(intent)
    }

    override fun onAdDismissed(reason: String?) {
        super.onAdDismissed(reason)
        (adListener as? InterstitialAdListener)?.onAdDismissed()
    }

}
