package com.particles.android.ads.internal

import android.content.Context
import android.os.Build
import com.particles.android.ads.NovaSdk
import com.particles.android.ads.internal.util.DeviceInfo

internal object NovaInternal {
    val context: Context get() {
        return NovaSdk.getContext()
    }

    var apiServer: String = "https://dsp.newsbreak.com/api"
        set(value) {
            if (value.isNotEmpty()) {
                field = value
            }
        }

    val osName = "android"
    val osVersion = Build.VERSION.RELEASE
    val appVersion by lazy { DeviceInfo.getAppVersionName(context) }

}