package com.particles.android.ads.internal.data.mapper

import org.json.JSONArray
import org.json.JSONObject

interface JsonMapper<T> : Mapper<JSONObject, T> {
    override fun map(source: JSONObject): T

    fun map(source: JSONArray): List<T> {
        val result = mutableListOf<T>()
        for (i in 0 until source.length()) {
            source.getJSONObject(i).let { result.add(map(it)) }
        }
        return result
    }
}
