package com.particles.android.ads.internal.domain

data class Ad(
    val raw: String,
    val requestId: String,
    val adId: String,
    val adSetId: String,
    val creative: Creative,
    val price: Double,
    val startTimeMillis: Long,
    val expireTimeMillis: Long,
    val encryptedAdToken: String,
    var localCachePath: String? = null,
)

data class Creative(
    val type: String,
    val adm: String,
    val headline: String,
    val body: String,
    val icon: Image?,
    val video: Video?,
    val addon: Addon?,
    val images: List<Image>,
    val isImageClickable: Boolean,
    val isVerticalMedia: Boolean,
    val starRating: Double,
    val advertiser: String,
    val callToAction: String,
    val clickThroughUrl: String,
    val browserOption: BrowserOption,
    val carouselItems: List<CarouselItem>,
    val impressionTrackingUrls: List<String>,
    val clickTrackingUrls: List<String>,
    val adVerifications: List<AdVerification>,
)

data class CarouselItem(
    val body: String,
    val image: Image?,
    val callToAction: String,
    val clickThroughUrl: String,
)

data class Video(
    val videoUrl: String,
    val coverUrl: String,
    val isAutoPlay: Boolean,
    val isLoopPlay: Boolean,
    val isMutePlay: Boolean,
    val isClickable: Boolean,
    val isContinuePlay: Boolean,
)

data class Image(val url: String, val width: Int, val height: Int)

enum class BrowserOption {
    IN_APP,
    BROWSER,
}
