package com.particles.android.ads.internal.domain

data class AdViewability(
    val viewportWidth: Int,
    val viewportHeight: Int,
    val viewTop: Int,
    val viewLeft: Int,
    val viewRight: Int,
    val viewBottom: Int,
    val visibleTime100: Long,
    val visibleTime75: Long,
    val visibleTime50: Long,
    val visibleTime25: Long,
    val visibleTime1: Long,
) {
    val viewportSize: String
        get() = "${viewportWidth},${viewportHeight}"

    val visibleTimes: String
        get() = "${visibleTime100},${visibleTime75},${visibleTime50},${visibleTime25},${visibleTime1}"

    val viewPosition: String
        get() = "${viewTop},${viewLeft},${viewBottom},${viewRight}"
}
