package com.particles.android.ads.internal.rendering

import android.content.Context
import android.graphics.Color
import android.webkit.*
import com.particles.android.ads.internal.util.WebViews

class AdWebView(context: Context): WebView(context) {

    var onAdClickThrough: ((url: String) -> Unit)? = null

    init {
        disableScrollingAndZoom()
        WebViews.setAllowDeviceContentAccess(settings, false)
        settings.javaScriptEnabled = true
        settings.domStorageEnabled = true
        settings.loadWithOverviewMode = true
        settings.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
        setBackgroundColor(Color.TRANSPARENT)

        webViewClient = object: WebViewClient() {
            override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
                if (url != null && WebViews.hasGesture(view)) {
                    onAdClickThrough?.invoke(url)
                    return true
                }
                return super.shouldOverrideUrlLoading(view, url)
            }

            override fun shouldOverrideUrlLoading(view: WebView?, request: WebResourceRequest?): Boolean {
                if (view != null && request != null) {
                    val isRedirect = request.isRedirect
                    val hasGesture = request.hasGesture() && WebViews.hasGesture(view)
                    val url = request.url.toString()
                    if (!isRedirect && hasGesture) {
                        onAdClickThrough?.invoke(url)
                        return true
                    }
                }

                return super.shouldOverrideUrlLoading(view, request)
            }

            override fun onRenderProcessGone(view: WebView?, detail: RenderProcessGoneDetail?): Boolean {
                return WebViews.onRenderProcessGone(view, detail)
            }
        }
    }

    fun loadHtml(html: String) {
        loadDataWithBaseURL("", html, "text/html", "UTF-8", "");
    }

    private fun disableScrollingAndZoom() {
        isHorizontalScrollBarEnabled = false
        setHorizontalScrollbarOverlay(false)
        isVerticalScrollBarEnabled = false
        setVerticalScrollbarOverlay(false)
        settings.setSupportZoom(false)
    }
}
