package com.particles.android.ads.internal.rendering.video

import android.content.Context
import androidx.media3.database.StandaloneDatabaseProvider
import androidx.media3.datasource.cache.LeastRecentlyUsedCacheEvictor
import androidx.media3.datasource.cache.SimpleCache
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import java.io.File

object NovaVideoCacheManager {

    private const val MAX_BYTES = 100 * 1024 * 1024L
    private const val DIR_NAME = "nova-sdk-video"

    @Volatile
    private var mSimpleCache: SimpleCache? = null

    @androidx.annotation.OptIn(androidx.media3.common.util.UnstableApi::class)
    fun getSimpleCache(context: Context) =
        mSimpleCache ?: synchronized(this) {
            mSimpleCache ?: SimpleCache(
                getCacheDirectory(context),
                LeastRecentlyUsedCacheEvictor(MAX_BYTES),
                StandaloneDatabaseProvider(context)
            ).also { mSimpleCache = it }
        }

    private fun getCacheDirectory(context: Context): File {
        return File(context.externalCacheDir ?: context.cacheDir, DIR_NAME).also {
            if (!it.exists()) {
                it.mkdirs()
            }
        }
    }

    @androidx.annotation.OptIn(androidx.media3.common.util.UnstableApi::class)
    fun release() {
        val cache = mSimpleCache
        if (cache != null) {
            CoroutineScope(Dispatchers.IO).launch {
                try {
                    cache.release()
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        }
        mSimpleCache = null
    }
}
