package com.particles.android.ads.internal.tracking

import com.particles.android.ads.internal.NovaInternal
import com.particles.android.ads.internal.domain.TrackingEvent
import okhttp3.HttpUrl.Companion.toHttpUrl

object EventTracker : Tracker() {

    fun fire(event: TrackingEvent) {
        try {
            val baseUrl = NovaInternal.apiServer + "/logAdEvent"
            val builder = baseUrl.toHttpUrl().newBuilder()
                .addQueryParameter("event_type", event.type)
                .addQueryParameter("action", event.action)
                .addQueryParameter("os", NovaInternal.osName)
                .addQueryParameter("osv", NovaInternal.osVersion)
                .addQueryParameter("cv", NovaInternal.appVersion)
                .addQueryParameter("user_id", event.userId)
                .addQueryParameter("profile_id", event.profileId)
                .addQueryParameter("session_id", event.sessionId)
                .addQueryParameter("ad_unit_id", event.adUnitId)
                .addQueryParameter("encrypted_ad_token", event.encryptedAdToken)
                .addQueryParameter("event_time", event.time.toString())

            if (event.reason != null) {
                builder.addQueryParameter("reason", event.reason)
            }

            if (event.offset > 0) {
                builder.addQueryParameter("offset", event.offset.toString())
            }

            if (event.duration > 0) {
                builder.addQueryParameter("duration_ms", event.duration.toString())
            }

            event.videoExtras?.let {
                builder
                    .addQueryParameter("is_play_automatically", it.isAutoPlay.toString())
                    .addQueryParameter("is_loop", it.isLoopPlay.toString())
                    .addQueryParameter("is_mute", it.isMutePlay.toString())
                    .addQueryParameter("is_video_clickable", it.isVideoClickable.toString())
                    .addQueryParameter("video_length", it.duration.toString())
                    .addQueryParameter("latency_ms", it.latency.toString())
            }

            event.videoProgressExtras?.let {
                builder
                    .addQueryParameter("video_length", it.duration.toString())
                    .addQueryParameter("position_ms", it.position.toString())
                    .addQueryParameter("loop_count", it.repeatCount.toString())
            }


            event.viewabilityExtras?.let {
                builder
                    .addQueryParameter("bs", it.viewportSize)
                    .addQueryParameter("mtos", it.timeOnScreenInMillis)
                    .addQueryParameter("p", it.creativePosition)
            }

            event.clickExtras?.let {
                builder.addQueryParameter("click_area_name", it.clickAreaName)
            }

            event.browserExtras?.let {
                if (it.seq > 0) {
                    builder.addQueryParameter("seq", it.seq.toString())
                }
                if (it.status > 0) {
                    builder.addQueryParameter("status", it.status.toString())
                }
                builder
                    .addQueryParameter("page_index", it.pageIndex.toString())
                    .addQueryParameter("scroll_depth", it.scrollDepth.toString())
            }

            event.extras?.entries?.filter { !it.key.startsWith('_') }?.forEach {
                builder.addQueryParameter("x_${it.key}", it.value.toString())
            }

            val url = builder.toString()

            fire(url)
        } catch (e: Exception) {
            // ignore
        }
    }
}
