package com.particles.android.ads.internal.util

import android.view.View
import com.particles.android.ads.internal.BaseAdImpl
import com.particles.android.ads.internal.domain.AdViewability
import com.particles.android.ads.internal.util.viewability.ViewabilityTracker

class AdViewHelper(private val view: View) {
    private var ad: BaseAdImpl? = null

    private var visibleNotified = false
    private var viewableNotified = false
    private val tracker = ViewabilityTracker(
        view,
        onViewabilityChanged = {
            if (!visibleNotified && it.visible) {
                visibleNotified = true
                ad?.onAdImpressed(view)
            }
            if (!viewableNotified && it.viewable) {
                viewableNotified = true
                ad?.onAdViewableImpressed(view, AdViewability(
                    viewportWidth = it.viewportWidth,
                    viewportHeight = it.viewportHeight,
                    viewTop = it.viewTop,
                    viewLeft = it.viewLeft,
                    viewRight = it.viewRight,
                    viewBottom = it.viewBottom,
                    visibleTime100 = it.visibleTime100,
                    visibleTime75 = it.visibleTime75,
                    visibleTime50 = it.visibleTime50,
                    visibleTime25 = it.visibleTime25,
                    visibleTime1 = it.visibleTime1,
                ))
            }
        },
    )

    fun register(ad: BaseAdImpl?) {
        visibleNotified = false
        viewableNotified = false
        this.ad = ad
        tracker.startTracking()
    }

    fun unregister() {
        tracker.stopTracking()
        this.ad = null
    }
}
