package com.particles.android.ads.internal.util

class Stopwatch {
    private var isRunning = false
    private var elapsedMills = 0L
    private var startTick = 0L

    fun isRunning(): Boolean {
        return isRunning
    }

    fun start() {
        if (isRunning) return

        isRunning = true
        startTick = tick()
    }

    fun stop() {
        if (!isRunning) return

        isRunning = false
        elapsedMills += tick() - startTick
    }

    fun reset() {
        elapsedMills = 0
        isRunning = false
    }

    fun elapsedMills(): Long {
        return elapsedMills + if (isRunning) tick() - startTick else 0
    }

    private fun tick(): Long {
        return System.currentTimeMillis()
    }
}
